/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.states;

import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustomBase;
import eu.vicci.process.model.sofiainstance.states.DeactivatedState;
import eu.vicci.process.model.sofiainstance.states.ExecutingState;
import eu.vicci.process.model.sofiainstance.states.StateBase;

public class ActiveState
extends StateBase {
    public ActiveState(ProcessStepInstanceImplCustomBase processStep) {
        super(processStep);
    }

    @Override
    public boolean execute() {
        if (!this.processStep.allStartPortsActive()) {
            if (this.processStep.hasAnyDeactivatedAndRequiredStartPort()) {
                this.processStep.logInfo("Required startport(s) deactivated. Process is going to deactivate.");
                this.processStep.preDeactivated();
                this.setDeactivatedIfPossible();
                return false;
            }
            this.processStep.logInfo("Process Step waiting on ports, can not be executed.");
            return false;
        }
        switch (this.processStep.getPermission()) {
            case GRANTED: {
                this.processStep.setCurrentState(new ExecutingState(this.processStep));
                return this.processStep.execute();
            }
            case DENIED: {
                return false;
            }
            case DELAYED: {
                this.processStep.executeDelay();
                return false;
            }
        }
        return false;
    }

    @Override
    public void processExecuted(ProcessStepInstanceImplCustom process) {
        this.setDeactivatedIfPossible();
    }

    @Override
    public State getSimpleState() {
        return State.ACTIVE;
    }

    private void setDeactivatedIfPossible() {
        if (this.processStep.allSubstepsHasFinishedExecution()) {
            this.processStep.setCurrentState(new DeactivatedState(this.processStep));
            this.processStep.postDeactivated();
        }
    }
}

