/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import akka.actor.ActorRef;
import eu.vicci.process.actors.ActorAssignable;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.MappingUtil;
import eu.vicci.process.model.sofiainstance.TransitionInstance;
import eu.vicci.process.model.sofiainstance.impl.TransitionInstanceImpl;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionInstanceImplCustom
extends TransitionInstanceImpl
implements ActorAssignable {
    private final Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private ActorRef actorReference = null;

    public void deploy(MappingUtil mapper) {
        this.deploy(mapper, null);
    }

    @Override
    public void deploy(MappingUtil mapper, ActorRef parent) {
        this.actorReference = LifeCycleManager.INSTANCE.createActorForTransitionSync((TransitionInstance)this, parent);
        if (this.getTransitionType().getTargetPort() == null) {
            return;
        }
        this.setTargetPortInstance(mapper.mapPort(this.getTransitionType().getTargetPort()));
        ActorAssignable targetPort = (ActorAssignable)this.getTargetPortInstance();
        targetPort.deploy(mapper, parent);
    }

    public void deactivate() {
        this.LOGGER.debug("{}: deactivate", (Object)this.getTransitionType().getName());
        if (this.getTransitionType().getTargetPort() != null) {
            LifeCycleManager.INSTANCE.deactivatePort(this.getTargetPortInstance());
        } else {
            this.LOGGER.error("{} has no endport!", (Object)this.getTransitionType().getName());
        }
    }

    public boolean execute(DataTypeInstance parameter) {
        this.LOGGER.debug("{}: execute", (Object)this.getTransitionType().getName());
        if (this.getTransitionType().getTargetPort() != null) {
            LifeCycleManager.INSTANCE.activatePortSync(this.getTargetPortInstance(), parameter);
        } else {
            this.LOGGER.error("{} has no endport!", (Object)this.getTransitionType().getName());
        }
        return true;
    }

    @Override
    public ActorRef getActorReference() {
        return this.actorReference;
    }
}

