/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import eu.vicci.process.model.sofiainstance.impl.StringTypeInstanceImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StringTypeInstanceImplCustom
extends StringTypeInstanceImpl {
    public DataTypeInstance copy() {
        StringTypeInstanceImplCustom newStringTypeInstance = new StringTypeInstanceImplCustom();
        if (this.value != null) {
            newStringTypeInstance.setValue(String.copyValueOf(this.value.toCharArray()));
        } else {
            newStringTypeInstance.setValue("");
        }
        newStringTypeInstance.setDataTypeType(this.getDataTypeType());
        newStringTypeInstance.setTypeId(this.getTypeId());
        newStringTypeInstance.setInstanceId(UUID.randomUUID().toString());
        return newStringTypeInstance;
    }

    public void parse(String text) {
        this.value = text;
    }

    public String serializeToXML() {
        String xml = "";
        if (this.getDataTypeType().getBelongsTo() == null) {
            xml = "<?xml version='1.0' encoding='UTF-8'?>";
        }
        xml = xml + "<" + this.getDataTypeType().getName() + ">" + this.getValue() + "</" + this.getDataTypeType().getName() + ">";
        return xml;
    }

    public boolean deserializeFromXML(String xmlInstance) {
        try {
            if (xmlInstance.trim().equals("")) {
                return false;
            }
            xmlInstance = this.removeXmlDeclaration(xmlInstance);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream inStreamTemp = new ByteArrayInputStream(xmlInstance.getBytes());
            InputSource inputSourceTemp = new InputSource(inStreamTemp);
            Document dataTypeDOM = db.parse(inputSourceTemp);
            String nodeName = dataTypeDOM.getFirstChild().getNodeName();
            String localName = this.getDataTypeType().getName();
            if (!localName.equals(nodeName)) {
                return false;
            }
            this.parse(dataTypeDOM.getFirstChild().getTextContent());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void createDummyData() {
        this.parse(UUID.randomUUID().toString());
    }

    private String removeXmlDeclaration(String xml) {
        if (xml.startsWith("<?xml")) {
            xml = xml.substring(xml.indexOf(">") + 1);
        }
        return xml;
    }

    public String toString() {
        return this.value;
    }

    public String serializeToJSON() {
        String json = "'" + this.getDataTypeType().getName() + "': '" + this.getValue() + "'";
        json = json.replace("'", "\"");
        return json;
    }

    public boolean deserializeFromJSON(String jsonString) {
        int pos2;
        boolean success = false;
        int pos = jsonString.indexOf("\"") + 1;
        String name = jsonString.substring(pos, pos2 = jsonString.indexOf(":") - 1);
        if (name.equals(this.getDataTypeType().getName())) {
            String value;
            success = true;
            Gson gson = new Gson();
            this.value = value = (String)gson.fromJson(jsonString, String.class);
        }
        return success;
    }

    public boolean deserializeFromOpenHabJason(String jsonString) {
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(jsonString).getAsJsonObject();
        if (obj == null || obj.isJsonNull()) {
            return false;
        }
        JsonElement element = obj.get(this.dataTypeType.getName());
        if (element == null || element.isJsonNull() || !element.isJsonPrimitive()) {
            return false;
        }
        this.value = element.getAsString();
        return true;
    }

    public String getValueAsObject() {
        return this.value;
    }

    public void setValueFromString(String value) {
        this.value = value;
    }

    public int compareTo(EObject o) {
        StringTypeInstance other = (StringTypeInstance)o;
        return this.getValue().compareTo(other.getValue());
    }
}

