/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import akka.actor.ActorRef;
import eu.vicci.process.actors.ActorAssignable;
import eu.vicci.process.model.sofia.DataMapping;
import eu.vicci.process.model.sofia.DataPort;
import eu.vicci.process.model.sofia.impl.DataPortImpl;
import eu.vicci.process.model.sofiainstance.ComplexTypeInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.MappingUtil;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.TransitionInstance;
import eu.vicci.process.model.sofiainstance.impl.StartDataPortInstanceImpl;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import eu.vicci.process.model.sofiainstance.util.PortUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartDataPortInstanceImplCustom
extends StartDataPortInstanceImpl
implements ActorAssignable {
    private final Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private ActorRef actorReference = null;
    protected volatile State executionState = State.INACTIVE;

    public void deploy(MappingUtil mapper) {
        this.deploy(mapper, null);
    }

    @Override
    public void deploy(MappingUtil mapper, ActorRef parent) {
        String presetValue;
        this.actorReference = LifeCycleManager.INSTANCE.createActorForStartDataPortSync((StartDataPortInstance)this, parent);
        PortUtil.deploy((PortInstance)this, mapper, this.actorReference);
        DataPortImpl dataPort = (DataPortImpl)this.getPortType();
        if (dataPort.getPortDatatype() != null) {
            this.dataInstance = mapper.mapDataType(dataPort.getPortDatatype());
        }
        if ((presetValue = dataPort.getValue()) != null && !presetValue.isEmpty()) {
            this.dataInstance.parse(presetValue);
        }
    }

    public boolean activate(DataTypeInstance parameter) {
        if (!this.canProceed()) {
            return true;
        }
        DataPort dp1 = (DataPort)this.getPortType();
        String dataPortTypeID = dp1.getPortDatatype().getId();
        if (parameter.getTypeId().equals(dataPortTypeID)) {
            this.dataInstance = parameter;
        } else {
            DataPort dp = (DataPort)this.getPortType();
            HashSet<DataMapping> mappings = new HashSet<DataMapping>((Collection<DataMapping>)dp.getMappings());
            this.dataInstance = this.mapp(parameter, mappings, this.getDataInstance());
        }
        this.executionState = State.ACTIVE;
        LifeCycleManager.INSTANCE.executeProcessStep(this.getProcessStepInstance());
        return true;
    }

    public void deactivate() {
        if (!this.canProceed()) {
            return;
        }
        this.executionState = State.DEACTIVATED;
        LifeCycleManager.INSTANCE.executeProcessStep(this.getProcessStepInstance());
    }

    public void deactivateSubSteps() {
        this.LOGGER.debug("{}: deactivate substeps", (Object)this.getPortType().getName());
        for (TransitionInstance t : this.getOutTransitionInstances()) {
            LifeCycleManager.INSTANCE.deactivateTransition(t);
        }
    }

    public synchronized void executeSubSteps() {
        this.LOGGER.debug("{}: activate substeps", (Object)this.getPortType().getName());
        this.setInstanceId("StartDataPort " + this.getPortType().getName() + "_instance_" + this.getInstancenumber());
        for (TransitionInstance t : this.getOutTransitionInstances()) {
            LifeCycleManager.INSTANCE.executeTransition(t, this.dataInstance.copy());
        }
    }

    public DataTypeInstance getDataInstance() {
        return this.dataInstance;
    }

    public void setDataInstance(DataTypeInstance newDataInstance) {
        this.dataInstance = newDataInstance;
    }

    @Override
    public ActorRef getActorReference() {
        return this.actorReference;
    }

    private DataTypeInstance getDataTypeInstanceByDataTypeId(String id, DataTypeInstance dti) {
        if (dti.getDataTypeType().getId().equals(id)) {
            return dti;
        }
        if (dti instanceof ComplexTypeInstance) {
            ComplexTypeInstance ct = (ComplexTypeInstance)dti;
            for (DataTypeInstance dataTypeInstance : ct.getSubtypes()) {
                DataTypeInstance d = this.getDataTypeInstanceByDataTypeId(id, dataTypeInstance);
                if (d == null) continue;
                return d;
            }
        }
        return null;
    }

    private DataTypeInstance mapp(DataTypeInstance sourceDataTypeInstance, Set<DataMapping> allMappings, DataTypeInstance targetDataTypeInstance) {
        for (DataMapping dm : allMappings) {
            String targetId = dm.getSource().getId();
            if (sourceDataTypeInstance == null) continue;
            DataTypeInstance dtiTarget = this.getDataTypeInstanceByDataTypeId(targetId, sourceDataTypeInstance);
            String classSource = sourceDataTypeInstance.getClass().getSimpleName();
            String classTarget = dtiTarget.getClass().getSimpleName();
            if (dtiTarget == null || !classSource.equals(classTarget)) continue;
            targetDataTypeInstance.parse(dtiTarget.toString());
        }
        return targetDataTypeInstance;
    }

    public void setExecutionState(State newExecutionState) {
        this.executionState = newExecutionState;
    }

    public State getExecutionState() {
        return this.executionState;
    }

    private boolean canProceed() {
        return this.executionState == State.INACTIVE;
    }
}

