/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import akka.actor.ActorRef;
import eu.vicci.process.actors.ActorAssignable;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.MappingUtil;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.StartControlPortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.TransitionInstance;
import eu.vicci.process.model.sofiainstance.impl.StartControlPortInstanceImpl;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import eu.vicci.process.model.sofiainstance.util.PortUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartControlPortInstanceImplCustom
extends StartControlPortInstanceImpl
implements ActorAssignable {
    private final Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private ActorRef actorReference = null;
    protected volatile State executionState = State.INACTIVE;

    public void deploy(MappingUtil mapper) {
        this.deploy(mapper, null);
    }

    @Override
    public void deploy(MappingUtil mapper, ActorRef parent) {
        this.actorReference = LifeCycleManager.INSTANCE.createActorForStartControlPortSync((StartControlPortInstance)this, parent);
        PortUtil.deploy((PortInstance)this, mapper, this.actorReference);
    }

    public boolean activate(DataTypeInstance parameter) {
        if (!this.canProceed()) {
            return true;
        }
        this.executionState = State.ACTIVE;
        LifeCycleManager.INSTANCE.executeProcessStep(this.getProcessStepInstance());
        return true;
    }

    public void deactivate() {
        if (!this.canProceed()) {
            return;
        }
        this.executionState = State.DEACTIVATED;
        LifeCycleManager.INSTANCE.executeProcessStep(this.getProcessStepInstance());
    }

    public void deactivateSubSteps() {
        this.LOGGER.debug("{}: deactivate substeps", (Object)this.getPortType().getName());
        this.setInstanceId("StartControlPort " + this.getPortType().getName() + "_instance_" + this.getInstancenumber());
        for (TransitionInstance t : this.getOutTransitionInstances()) {
            LifeCycleManager.INSTANCE.deactivateTransition(t);
        }
    }

    public void executeSubSteps() {
        this.LOGGER.debug("{}: activate substeps", (Object)this.getPortType().getName());
        this.setInstanceId("StartControlPort " + this.getPortType().getName() + "_instance_" + this.getInstancenumber());
        for (TransitionInstance t : this.getOutTransitionInstances()) {
            LifeCycleManager.INSTANCE.executeTransition(t);
        }
    }

    @Override
    public ActorRef getActorReference() {
        return this.actorReference;
    }

    public void setExecutionState(State newExecutionState) {
        this.executionState = newExecutionState;
    }

    public State getExecutionState() {
        return this.executionState;
    }

    private boolean canProceed() {
        return this.executionState == State.INACTIVE;
    }
}

