/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import akka.actor.ActorRef;
import eu.vicci.process.model.sofia.SOAPInvoke;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.EndPortInstance;
import eu.vicci.process.model.sofiainstance.MappingUtil;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.SOAPInvokeInstance;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.util.SOAPWorker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPInvokeInstanceImplCustom
extends ProcessStepInstanceImplCustom
implements SOAPInvokeInstance {
    private DocumentBuilder db;
    private String returnMessage = null;
    private String exampleMessage = null;
    private SOAPWorker soapWorker = null;

    @Override
    public void onDeploy(MappingUtil mapper, ActorRef parent) {
        super.deploy(mapper);
        SOAPInvoke si = (SOAPInvoke)this.getProcessStepType();
        this.soapWorker = new SOAPWorker(si.getServerUri(), si.getWsdlUri(), null, si.getMethodName(), 100);
        this.exampleMessage = this.soapWorker.getDummyRequestString();
    }

    @Override
    public void work() {
        String requestMessage = this.createRequest();
        this.returnMessage = this.soapWorker.sendRequest(requestMessage);
        System.out.println("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + this.returnMessage);
    }

    @Override
    public void activateDataEndPorts() {
        for (PortInstance port : this.ports) {
            DataTypeInstance dataInstance = null;
            if (!(port instanceof EndPortInstance) || !(port instanceof EndDataPortInstance) || !(dataInstance = ((EndDataPortInstance)port).getDataInstance()).deserializeFromXML(this.returnMessage)) continue;
            port.activate(dataInstance);
        }
    }

    private String printSOAPResponse(SOAPMessage soapResponse) {
        String value = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter sw = new StringWriter();
            if (soapResponse.getSOAPPart().getFirstChild().getFirstChild().getFirstChild() != null) {
                transformer.transform(new DOMSource(soapResponse.getSOAPPart().getFirstChild().getFirstChild().getFirstChild()), new StreamResult(sw));
                value = sw.toString();
                value = this.removeXmlDeclaration(value);
                int numberOfEntries = soapResponse.getSOAPPart().getFirstChild().getFirstChild().getFirstChild().getChildNodes().getLength();
                System.out.println("Number of entries: " + numberOfEntries);
                if (numberOfEntries == 1) {
                    value = this.removeRootTag(value);
                }
                value = value.replace("\r\n", "");
                System.out.println("\n Response SOAP Message = " + value);
            } else {
                System.out.println("\n Response SOAP Message -> only acknowledgment?");
            }
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        return value;
    }

    private String removeNameSpace(String s) {
        if (s.contains(":")) {
            return s.split(":")[1];
        }
        return s;
    }

    private String createRequest() {
        System.out.println("Build request!");
        String finalRequest = "";
        try {
            SOAPInvoke si = (SOAPInvoke)this.getProcessStepType();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.db = dbf.newDocumentBuilder();
            String operationName = si.getMethodName();
            ByteArrayInputStream inStream = new ByteArrayInputStream(this.exampleMessage.getBytes());
            InputSource inputSource = new InputSource(inStream);
            Document exampleRequestDOM = this.db.parse(inputSource);
            Node bodyPart = exampleRequestDOM.getElementsByTagName("soapenv:Body").item(0);
            NodeList operationNodes = bodyPart.getChildNodes();
            for (int i = 0; i < operationNodes.getLength(); ++i) {
                String listedOperation = operationNodes.item(i).getNodeName();
                if (!(listedOperation = this.removeNameSpace(listedOperation)).equals(operationName)) continue;
                NodeList operationParameters = operationNodes.item(i).getChildNodes();
                for (int a = 0; a < operationParameters.getLength(); ++a) {
                    String xmlName = operationParameters.item(a).getNodeName();
                    xmlName = this.removeNameSpace(xmlName);
                    for (DataTypeInstance dataType : this.startParameter) {
                        dataType.toString();
                        String dataTypeName = dataType.getDataTypeType().getName();
                        if (!dataTypeName.equals(xmlName)) continue;
                        String dataTypeSerializedToXML = dataType.serializeToXML();
                        ByteArrayInputStream inStreamTemp = new ByteArrayInputStream(dataTypeSerializedToXML.getBytes());
                        InputSource inputSourceTemp = new InputSource(inStreamTemp);
                        Document dataTypeDOM = this.db.parse(inputSourceTemp);
                        operationNodes.item(i).removeChild(operationParameters.item(a));
                        Node importedNode = exampleRequestDOM.importNode(dataTypeDOM.getFirstChild(), true);
                        operationNodes.item(i).appendChild(importedNode);
                    }
                }
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(exampleRequestDOM), new StreamResult(writer));
            finalRequest = writer.getBuffer().toString();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\n Final Request: " + finalRequest + " end");
        return finalRequest;
    }

    private String removeXmlDeclaration(String xml) {
        if (xml.startsWith("<?xml")) {
            xml = xml.substring(xml.indexOf(">") + 1);
        }
        return xml;
    }

    private String removeRootTag(String xmlIn) {
        String xmlOut = xmlIn.substring(xmlIn.indexOf(">") + 1, xmlIn.lastIndexOf("<"));
        xmlOut = xmlOut.trim();
        return xmlOut;
    }
}

