/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.vicci.process.model.sofia.HTTPverb;
import eu.vicci.process.model.sofia.RESTInvoke;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.EndPortInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.RESTInvokeInstance;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import eu.vicci.process.model.sofiainstance.util.RESTInvokeWorker;

public class RESTInvokeInstanceImplCustom
extends ProcessStepInstanceImplCustom
implements RESTInvokeInstance {
    private String returnMessage = "";
    private String serverUri = "";

    @Override
    public void work() {
        try {
            HTTPverb httpVerb = null;
            if (this.getProcessStepType() instanceof RESTInvoke) {
                RESTInvoke ri = (RESTInvoke)this.getProcessStepType();
                this.serverUri = ri.getServerUri();
                httpVerb = ri.getHTTPMethod();
            }
            RESTInvokeWorker worker = new RESTInvokeWorker(this.serverUri);
            switch (httpVerb) {
                case DELETE: {
                    worker.executeXMLDeleteCall();
                    break;
                }
                case GET: {
                    this.returnMessage = worker.executeXMLGetCall();
                    break;
                }
                case POST: {
                    Object string = ((DataTypeInstance)this.startParameter.get(0)).getValueAsObject();
                    if (!(string instanceof String)) {
                        return;
                    }
                    worker.executeXMLPostCall((String)string);
                    break;
                }
                case PUT: {
                    worker.executeXMLPutCall(((DataTypeInstance)this.startParameter.get(0)).serializeToXML());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void activateDataEndPorts() {
        for (PortInstance port : this.ports) {
            DataTypeInstance dataInstance = null;
            if (!(port instanceof EndPortInstance) || !(port instanceof EndDataPortInstance)) continue;
            EndDataPortInstance pi = (EndDataPortInstance)port;
            dataInstance = pi.getDataInstance();
            this.deserializeAndActivatePort(pi, dataInstance);
        }
    }

    private void deserializeAndActivatePort(EndDataPortInstance port, DataTypeInstance dataInstance) {
        if (this.isCompensatingPort((PortInstance)port)) {
            return;
        }
        if (this.serverUri.contains("rest/items") || this.serverUri.contains("rest/things")) {
            String typeName = port.getDataInstance().getDataTypeType().getName();
            String valueReceived = this.deserializeFromOpenHabJason(this.returnMessage, typeName);
            if (valueReceived == null) {
                this.LOGGER.error("cant get value for port. Port is not activated: {}", (Object)typeName);
                return;
            }
            try {
                dataInstance.parse(valueReceived);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.LOGGER.error("cant parse the received value to the port datainstance. port is not activated. {}", (Object)port.getName());
                return;
            }
            LifeCycleManager.INSTANCE.activatePort((PortInstance)port, dataInstance);
        } else if (dataInstance.deserializeFromJSON(this.returnMessage)) {
            LifeCycleManager.INSTANCE.activatePort((PortInstance)port, dataInstance);
        }
    }

    private String deserializeFromOpenHabJason(String jsonString, String propertyName) {
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(jsonString).getAsJsonObject();
        if (obj == null || obj.isJsonNull()) {
            return null;
        }
        JsonElement element = obj.get(propertyName);
        if (element == null || element.isJsonNull() || !element.isJsonPrimitive()) {
            return null;
        }
        return element.getAsString();
    }
}

