/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import akka.actor.ActorRef;
import eu.vicci.process.actors.ActorAssignable;
import eu.vicci.process.distribution.manager.DistributionManager;
import eu.vicci.process.engine.core.IProcessManager;
import eu.vicci.process.model.sofia.CompositeStep;
import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.Configuration;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndControlPortInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.EndPortInstance;
import eu.vicci.process.model.sofiainstance.EscalationPortInstance;
import eu.vicci.process.model.sofiainstance.ExecutionPermission;
import eu.vicci.process.model.sofiainstance.MappingUtil;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.StartControlPortInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.StartPortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.impl.ProcessStepInstanceImpl;
import eu.vicci.process.model.sofiainstance.states.ProcessExecutedListener;
import eu.vicci.process.model.sofiainstance.states.ProcessResetListener;
import eu.vicci.process.model.sofiainstance.states.StateBase;
import eu.vicci.process.model.sofiainstance.states.StateChangable;
import eu.vicci.process.model.sofiainstance.states.UndeployedState;
import eu.vicci.process.model.sofiainstance.util.InternalProcessStepInterface;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import eu.vicci.process.model.sofiainstance.util.ProcessStepTimerTask;
import eu.vicci.process.model.util.logging.LoggingManager;
import eu.vicci.process.model.util.messages.MessageQueue;
import eu.vicci.process.model.util.messages.StateChangeMessage;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.IWampMessage;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONDataPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONPortInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessStepInstanceImplCustomBase
extends ProcessStepInstanceImpl
implements InternalProcessStepInterface,
StateChangable,
ActorAssignable {
    protected final Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    protected List<DataTypeInstance> startParameter = new ArrayList<DataTypeInstance>();
    protected List<DataTypeInstance> endParameter = new ArrayList<DataTypeInstance>();
    protected List<DataTypeInstance> returnValues = new ArrayList<DataTypeInstance>();
    protected List<ProcessExecutedListener> processExecutedListeners = new ArrayList<ProcessExecutedListener>();
    protected List<ProcessResetListener> processResetListener = new ArrayList<ProcessResetListener>();
    protected volatile StateBase currentState;
    protected Timer timer;
    protected ProcessStepTimerTask timerTask;
    protected Timer stateTimer = new Timer();
    protected ActorRef actorReference;
    protected volatile State executionState;
    protected MessageQueue messageQueue;
    protected IProcessManager processManager;
    protected final boolean runsOnPeer;
    protected final String peerId;

    public ProcessStepInstanceImplCustomBase() {
        this.currentState = new UndeployedState(this);
        this.executionState = this.currentState.getSimpleState();
        this.delay = 0L;
        this.peerId = DistributionManager.getInstance().getPeerId();
        this.runsOnPeer = !DistributionManager.getInstance().isSuperPeer();
    }

    @Override
    public void setCurrentState(StateBase currentState) {
        if (currentState == null) {
            throw new IllegalArgumentException("the state can\u00b4t be null");
        }
        if (this.currentState.getSimpleState() == currentState.getSimpleState()) {
            return;
        }
        this.currentState = currentState;
        this.changeExecutionState(currentState.getSimpleState());
    }

    public final void pause() {
        this.currentState.pause();
    }

    public final void resume() {
        this.currentState.resume();
    }

    public final void stop() {
        this.currentState.stop();
    }

    public final boolean execute() {
        this.logInfo(this.getExecutionState().toString() + " permission: " + this.getPermission());
        return this.currentState.execute();
    }

    public final void kill() {
        this.currentState.kill();
    }

    public final void reset() {
        this.currentState.reset();
    }

    public final boolean hasFinishedExecution() {
        return this.currentState.hasFinishedExecution();
    }

    public final synchronized void deploy(MappingUtil mapper) {
        this.currentState.deploy(mapper, null);
    }

    @Override
    public final synchronized void deploy(MappingUtil mapper, ActorRef parent) {
        this.currentState.deploy(mapper, parent);
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    @Override
    public ProcessStepTimerTask getTimerTask() {
        return this.timerTask;
    }

    @Override
    public void setTimerTask(ProcessStepTimerTask timerTask) {
        this.timerTask = timerTask;
    }

    @Override
    public List<DataTypeInstance> getStartParameter() {
        return this.startParameter;
    }

    @Override
    public void setStartParameter(List<DataTypeInstance> startParameter) {
        this.startParameter = startParameter;
    }

    public List<DataTypeInstance> getEndParameter() {
        return this.endParameter;
    }

    public void setEndParameter(List<DataTypeInstance> endParameter) {
        this.endParameter = endParameter;
    }

    @Override
    public List<DataTypeInstance> getReturnValues() {
        return this.returnValues;
    }

    @Override
    public void setReturnValues(List<DataTypeInstance> returnValues) {
        this.returnValues = returnValues;
    }

    @Override
    public ActorRef getActorReference() {
        return this.actorReference;
    }

    public void setMessageQueue(MessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    public void setProcessManager(IProcessManager processManager) {
        this.processManager = processManager;
    }

    @Override
    public void logInfo(String info) {
        this.LOGGER.info("{}: {}", (Object)this.getProcessStepType().getName(), (Object)info);
    }

    public void logInfo(String info, Object ... objects) {
        this.LOGGER.info(info, objects);
    }

    @Override
    public boolean allStartPortsActive() {
        return !this.getPorts().stream().filter(port -> port instanceof StartPortInstance).anyMatch(port -> port.getExecutionState() != State.ACTIVE && !port.getPortType().isOptional());
    }

    public boolean hasAnyDeactivatedAndRequiredStartPort() {
        return this.getPorts().stream().filter(port -> port instanceof StartPortInstance).anyMatch(port -> port.getExecutionState() == State.DEACTIVATED && !port.getPortType().isOptional());
    }

    public void addProcessExecutedListener(ProcessExecutedListener listener) {
        this.processExecutedListeners.add(listener);
    }

    public void addProcessResetListener(ProcessResetListener listener) {
        this.processResetListener.add(listener);
    }

    @Override
    public void changeExecutionState(State state) {
        this.executionState = state;
        StateChangeMessage scm = this.createStateChangeMessage();
        this.addSerializedPortsToMessage(scm);
        LoggingManager.getInstance().logStateMessage((IStateChangeMessage)scm);
        if (this.messageQueue != null) {
            this.messageQueue.addMessage((IWampMessage)scm);
        } else {
            this.LOGGER.warn("There is no message Queue set on '{}'.", (Object)this.getProcessStepType().getName());
        }
    }

    public State getExecutionState() {
        return this.currentState.getSimpleState();
    }

    public StateBase getCurrentState() {
        return this.currentState;
    }

    public void activateEscalationPort() {
        for (PortInstance port : this.getPorts()) {
            if (!(port instanceof EscalationPortInstance)) continue;
            LifeCycleManager.INSTANCE.activatePortSync(port);
        }
    }

    public void escalate() {
        this.currentState.escalate();
    }

    @Override
    public void executeDelay() {
        if (this.getTimer() == null) {
            Timer timer = new Timer();
            ProcessStepTimerTask timerTask = new ProcessStepTimerTask((ProcessStepInstance)this);
            timer.schedule((TimerTask)timerTask, this.getDelay());
            this.LOGGER.error("Timer scheduled");
        }
    }

    @Override
    public void activateDataEndPorts() {
        if (!this.getReturnValues().isEmpty()) {
            for (PortInstance port : this.getPorts()) {
                if (!(port instanceof EndDataPortInstance)) continue;
                DataPortInstance port1 = (DataPortInstance)port;
                for (DataTypeInstance dataInstance : this.getReturnValues()) {
                    String wantedDataId;
                    String dataId = dataInstance.getDataTypeType().getId();
                    if (!dataId.equals(wantedDataId = port1.getDataInstance().getDataTypeType().getId())) continue;
                    LifeCycleManager.INSTANCE.activatePortSync(port, dataInstance);
                }
            }
        }
    }

    @Override
    public void aggregateStartParameter() {
        this.startParameter.clear();
        for (PortInstance port : this.getPorts()) {
            if (!(port instanceof StartDataPortInstance)) continue;
            DataPortInstance dataPortInstance = (DataPortInstance)port;
            this.getStartParameter().add(dataPortInstance.getDataInstance());
        }
    }

    @Override
    public void aggregateEndParameter() {
        this.endParameter.clear();
        for (PortInstance port : this.getPorts()) {
            if (!(port instanceof EndDataPortInstance)) continue;
            DataPortInstance dataPortInstance = (DataPortInstance)port;
            this.getEndParameter().add(dataPortInstance.getDataInstance());
        }
    }

    @Override
    public void activateControlEndPorts() {
        for (PortInstance port : this.getPorts()) {
            if (!(port instanceof EndControlPortInstance) || port instanceof EscalationPortInstance) continue;
            LifeCycleManager.INSTANCE.activatePortSync(port);
        }
    }

    @Deprecated
    public void setExecutionState(State newExecutionState) {
        switch (newExecutionState) {
            case EXECUTING: {
                LifeCycleManager.INSTANCE.executeProcessStep((ProcessStepInstance)this);
                break;
            }
            case KILLED: {
                LifeCycleManager.INSTANCE.killProcessStep(this);
                break;
            }
            case PAUSED: {
                LifeCycleManager.INSTANCE.pauseProcessStep(this);
                break;
            }
            case STOPPED: {
                LifeCycleManager.INSTANCE.stopProcessStep(this);
                break;
            }
        }
    }

    @Override
    public void startSubProcesses() {
        for (PortInstance port : this.getPorts()) {
            if (!(port instanceof StartPortInstance)) continue;
            StartPortInstance startPort = (StartPortInstance)port;
            startPort.executeSubSteps();
        }
    }

    @Override
    public void cancelTimer() {
        if (this.getTimer() != null) {
            this.getTimer().cancel();
        }
    }

    public boolean allSubstepsHasFinishedExecution() {
        for (ProcessStepInstance psi : this.getSubSteps()) {
            if (((ProcessStepInstanceImplCustomBase)psi).hasFinishedExecution()) continue;
            return false;
        }
        return true;
    }

    public boolean allSubstepsAreReset() {
        if (this.getSubSteps().size() == 0) {
            return true;
        }
        return this.getSubSteps().stream().allMatch(step -> step.getExecutionState() == State.INACTIVE);
    }

    public void setPermission(ExecutionPermission newPermission) {
        this.permission = newPermission;
        if (this.getExecutionState() == State.ACTIVE) {
            LifeCycleManager.INSTANCE.executeProcessStep((ProcessStepInstance)this);
        }
    }

    public void setDelay(long newDelay) {
        this.delay = newDelay;
        if (this.getTimer() != null && this.getTimerTask() != null) {
            this.getTimerTask().cancel();
            this.getTimer().schedule((TimerTask)this.getTimerTask(), newDelay);
        }
    }

    @Override
    public void forwardReactivation() {
        for (PortInstance port : this.getPorts()) {
            if (!(port instanceof EndPortInstance)) continue;
            LifeCycleManager.INSTANCE.activatePort(port);
        }
    }

    public boolean allEndPortsHaveTheState(State askedState) {
        boolean anyEndport = this.getPorts().stream().anyMatch(p -> p instanceof EndPortInstance && !(p instanceof EscalationPortInstance));
        if (!anyEndport) {
            return true;
        }
        return this.getPorts().stream().filter(p -> p instanceof EndPortInstance && !(p instanceof EscalationPortInstance)).allMatch(p -> p.getExecutionState() == askedState);
    }

    public boolean allEndPortsAreDeactivatedOrActivated() {
        boolean anyEndport = this.getPorts().stream().anyMatch(p -> p instanceof EndPortInstance && !(p instanceof EscalationPortInstance));
        if (!anyEndport) {
            return true;
        }
        return this.getPorts().stream().filter(p -> p instanceof EndPortInstance && !(p instanceof EscalationPortInstance)).allMatch(p -> p.getExecutionState() == State.ACTIVE || p.getExecutionState() == State.DEACTIVATED);
    }

    public abstract void doingEndoperations();

    public String configure(Configuration conf) {
        boolean correctId = false;
        this.LOGGER.debug("configure step: {}", (Object)this.getProcessStepType().getId());
        if (this.getProcessStepType().getId().equals(conf.getInstanceId())) {
            this.configure1(conf);
            correctId = true;
        } else if (conf.getInstanceId() == null) {
            this.configure1(conf);
        }
        if (this.getProcessStepType() instanceof CompositeStep && !correctId) {
            for (ProcessStepInstance inst : this.getSubSteps()) {
                inst.configure(conf);
            }
        }
        return "";
    }

    public List<StartPortInstance> getStartPorts() {
        return this.getPorts().stream().filter(p -> p instanceof StartPortInstance).map(StartPortInstance.class::cast).collect(Collectors.toList());
    }

    protected boolean runsCompensation() {
        return this.getProcessStepType().getGoal() != null && !this.getProcessStepType().getGoal().trim().isEmpty();
    }

    protected boolean isCompensatingPort(PortInstance port) {
        if (!this.runsCompensation()) {
            return false;
        }
        if (!(port instanceof DataPortInstance)) {
            return false;
        }
        DataPortInstance dpi = (DataPortInstance)port;
        DataTypeInstance dti = dpi.getDataInstance();
        if (!(dti instanceof BooleanTypeInstance)) {
            return false;
        }
        return "HasBeenFinished".equals(dti.getName()) || "HasBeenSatisfied".equals(dti.getName());
    }

    private StateChangeMessage createStateChangeMessage() {
        StateChangeMessage scm = new StateChangeMessage();
        if (this.runsOnPeer) {
            scm.setPeerId(this.peerId);
        }
        scm.setProcessInstanceId(this.getProcessInstanceID());
        scm.setProcessModelId(this.getProcessModelID());
        scm.setInstanceId(this.getInstanceId());
        scm.setModelId(this.getProcessModelID());
        scm.setState(this.getExecutionState());
        scm.setProcessId(this.getProcessStepType().getId());
        scm.setProcessName(this.getProcessStepType().getName());
        scm.setOriginalProcessInstanceId(this.getOriginalProcessInstanceId());
        return scm;
    }

    protected String getOriginalProcessInstanceId() {
        return null;
    }

    private void addSerializedPortsToMessage(StateChangeMessage message) {
        HashMap<String, JSONDataPortInstance> startDataTypes = new HashMap<String, JSONDataPortInstance>();
        HashMap<String, JSONDataPortInstance> endDataTypes = new HashMap<String, JSONDataPortInstance>();
        HashMap<String, JSONPortInstance> startControlPorts = new HashMap<String, JSONPortInstance>();
        HashMap<String, JSONPortInstance> endControlPorts = new HashMap<String, JSONPortInstance>();
        for (PortInstance pi : this.getPorts()) {
            JSONDataPortInstance dto;
            if (pi instanceof StartDataPortInstance) {
                dto = new JSONDataPortInstance((DataPortInstance)pi);
                startDataTypes.put(pi.getPortType().getId(), dto);
                continue;
            }
            if (pi instanceof EndDataPortInstance) {
                dto = new JSONDataPortInstance((DataPortInstance)((EndDataPortInstance)pi));
                endDataTypes.put(pi.getPortType().getId(), dto);
                continue;
            }
            if (pi instanceof StartControlPortInstance) {
                startControlPorts.put(pi.getPortType().getId(), new JSONPortInstance(pi));
                continue;
            }
            if (!(pi instanceof EndControlPortInstance)) continue;
            endControlPorts.put(pi.getPortType().getId(), new JSONPortInstance(pi));
        }
        message.setStartDataPorts(startDataTypes);
        message.setEndDataPorts(endDataTypes);
        message.setStartControlPorts(startControlPorts);
        message.setEndControlPorts(endControlPorts);
    }

    private void configure1(Configuration conf) {
        if (conf.getDelay() >= 0L) {
            this.setDelay(conf.getDelay());
        }
        if (conf.getPermission() != null) {
            this.setPermission(conf.getPermission());
        }
    }
}

