/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import akka.actor.ActorRef;
import eu.vicci.process.actors.ActorAssignable;
import eu.vicci.process.model.sofia.CompositeStep;
import eu.vicci.process.model.sofia.EscalationPort;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofiainstance.EndPortInstance;
import eu.vicci.process.model.sofiainstance.EscalationPortInstance;
import eu.vicci.process.model.sofiainstance.MappingUtil;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.StartPortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.impl.custom.EscalationPortInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustomBase;
import eu.vicci.process.model.sofiainstance.states.PortExecutionStateChangedListener;
import eu.vicci.process.model.sofiainstance.states.PortExecutionStateListenable;
import eu.vicci.process.model.sofiainstance.states.ProcessExecutedListener;
import eu.vicci.process.model.sofiainstance.states.ProcessResetListener;
import eu.vicci.process.model.sofiainstance.util.CheckStateTask;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import java.util.Date;
import java.util.TimerTask;
import org.eclipse.emf.common.util.EList;

public class ProcessStepInstanceImplCustom
extends ProcessStepInstanceImplCustomBase
implements ProcessExecutedListener,
ProcessResetListener,
PortExecutionStateChangedListener {
    @Override
    public void work() {
    }

    @Override
    public void onDeploy(MappingUtil mapper, ActorRef parent) {
        this.actorReference = LifeCycleManager.INSTANCE.createActorForProcessSync(this, parent);
        this.deploySubsteps(mapper);
        this.deployPorts(mapper);
        this.addListenerToSubsteps();
        this.addListenerToEndPorts();
    }

    @Override
    public boolean onExecute() {
        this.logInfo("-------------> execution started");
        this.cancelTimer();
        this.aggregateStartParameter();
        this.aggregateEndParameter();
        this.startSubProcesses();
        this.startStateTimerIfNeeded();
        this.work();
        if (this.allSubstepsHasFinishedExecution()) {
            this.doingEndoperations();
        }
        return true;
    }

    @Override
    public void onKill() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onEscalate() {
        if (this.stateTimer == null) {
            return;
        }
        this.stateTimer.cancel();
        this.logInfo("-------------> escalation started");
        this.deactivateAllEndports(false);
        this.activateEscalationPort();
    }

    @Override
    public void postEscalated() {
        this.logInfo("------------>>> Escalated <<<--------------");
        if (this.processExecutedListeners.isEmpty()) {
            this.LOGGER.error("no executed listeners are set");
        }
        for (ProcessExecutedListener listener : this.processExecutedListeners) {
            LifeCycleManager.INSTANCE.processExecuted(listener, this);
        }
    }

    @Override
    public void postExecuted() {
        this.logInfo("------------>>> Executed <<<--------------");
        if (this.processExecutedListeners.isEmpty()) {
            this.LOGGER.error("no executed listeners are set");
        }
        for (ProcessExecutedListener listener : this.processExecutedListeners) {
            LifeCycleManager.INSTANCE.processExecuted(listener, this);
        }
    }

    @Override
    public void preReset() {
        this.setAllPortsToInactive();
        this.resetAllSubsteps();
    }

    @Override
    public void postReset() {
        this.logInfo("------------>>> Reset <<<--------------");
        if (this.processResetListener.isEmpty()) {
            this.LOGGER.error("no reset listeners are set");
        }
        for (ProcessResetListener listener : this.processResetListener) {
            LifeCycleManager.INSTANCE.processReset(listener, this);
        }
    }

    @Override
    public void processExecuted(ProcessStepInstanceImplCustom process) {
        this.currentState.processExecuted(process);
    }

    @Override
    public void processReset(ProcessStepInstanceImplCustom process) {
        this.currentState.processReset(process);
    }

    @Override
    public void portExecutionStateChanged(PortInstance port) {
        this.currentState.portExecutionStateChanged(port);
    }

    @Override
    public void postDeactivated() {
        this.logInfo("------------>>> Deactivated <<<--------------");
        if (this.processExecutedListeners.isEmpty()) {
            this.LOGGER.error("no executed listeners are set");
        }
        for (ProcessExecutedListener listener : this.processExecutedListeners) {
            LifeCycleManager.INSTANCE.processExecuted(listener, this);
        }
    }

    @Override
    public void preDeactivated() {
        this.deactivateAllEndports();
        this.deactivateAllSubsteps();
    }

    @Override
    public void doingEndoperations() {
        this.stateTimer.cancel();
        this.activateControlEndPorts();
        this.activateDataEndPorts();
        this.deactivateEscalationPorts();
    }

    private void deactivateEscalationPorts() {
        this.ports.stream().filter(port -> port instanceof EscalationPortInstanceImplCustom).forEach(port -> LifeCycleManager.INSTANCE.deactivatePort((PortInstance)port));
    }

    protected void setAllPortsToInactive() {
        for (PortInstance port : this.getPorts()) {
            LifeCycleManager.INSTANCE.changePortExecutionState(port, State.INACTIVE);
        }
    }

    protected void resetAllSubsteps() {
        for (ProcessStepInstance process : this.getSubSteps()) {
            LifeCycleManager.INSTANCE.resetProcess(process);
        }
    }

    private void deploySubsteps(MappingUtil mapper) {
        if (this.getProcessStepType() instanceof CompositeStep) {
            CompositeStep sofiaModelCompositeStep = (CompositeStep)this.getProcessStepType();
            EList steps = sofiaModelCompositeStep.getSubSteps();
            ProcessStepInstanceImplCustomBase instance = null;
            for (ProcessStep step : steps) {
                instance = (ProcessStepInstanceImplCustomBase)mapper.mapProcessStep(step);
                instance.deploy(mapper, this.actorReference);
                this.getSubSteps().add((Object)instance);
            }
        }
    }

    protected void startStateTimerIfNeeded() {
        long escalationTime = 0L;
        boolean escalationAvailable = false;
        for (PortInstance piend : this.getPorts()) {
            if (!(piend instanceof EscalationPortInstance)) continue;
            escalationAvailable = true;
            EscalationPort ep = (EscalationPort)piend.getPortType();
            long escalationTimeMins = ep.getEscalationTime();
            escalationTime = escalationTimeMins * 1000L;
        }
        if (!escalationAvailable) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long timeOut = currentTime + escalationTime;
        CheckStateTask cst = new CheckStateTask();
        cst.setProcessStepInstance((ProcessStepInstance)this);
        cst.setTimeOut(timeOut);
        cst.setInterruptedThread(Thread.currentThread());
        Date time = new Date(timeOut);
        this.stateTimer.schedule((TimerTask)cst, time);
    }

    private void deployPorts(MappingUtil mapper) {
        boolean isMapped = false;
        for (Port p : this.getProcessStepType().getPorts()) {
            isMapped = false;
            for (PortInstance instance : this.getPorts()) {
                if (!instance.getPortType().getId().equals(p.getId())) continue;
                isMapped = true;
            }
            if (isMapped) continue;
            PortInstance portInstance = mapper.mapPort(p);
            this.getPorts().add((Object)portInstance);
            ((ActorAssignable)portInstance).deploy(mapper, this.actorReference);
        }
    }

    private void addListenerToSubsteps() {
        for (ProcessStepInstance instance : this.getSubSteps()) {
            ProcessStepInstanceImplCustomBase step = (ProcessStepInstanceImplCustomBase)instance;
            step.addProcessExecutedListener(this);
            step.addProcessResetListener(this);
        }
    }

    private void addListenerToEndPorts() {
        this.getPorts().stream().filter(port -> port instanceof PortExecutionStateListenable).forEach(port -> ((PortExecutionStateListenable)port).addPortExecutionStateChangedListener(this));
    }

    private void deactivateAllEndports() {
        this.deactivateAllEndports(true);
    }

    private void deactivateAllEndports(boolean deactivateEscalationPort) {
        this.getPorts().stream().filter(port -> port instanceof EndPortInstance && !(port instanceof EscalationPortInstance)).forEach(port -> LifeCycleManager.INSTANCE.deactivatePort((PortInstance)port));
    }

    private void deactivateAllSubsteps() {
        this.getPorts().stream().filter(port -> port instanceof StartPortInstance).forEach(port -> ((StartPortInstance)port).deactivateSubSteps());
    }
}

