/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.StartControlPortInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import java.util.Map;

public class ProcessInstanceImplCustom
extends ProcessStepInstanceImplCustom
implements ProcessInstance {
    private volatile String runningForInstanceId;

    public boolean start(Map<String, DataTypeInstance> parameters) {
        this.logInfo("Process start");
        if (parameters != null && !parameters.isEmpty()) {
            this.activateStartDataPortsWithParamter(parameters);
        } else {
            this.getPorts().stream().filter(port -> port instanceof StartDataPortInstance).forEach(port -> this.tryActivateStartDataPort((StartDataPortInstance)port));
        }
        for (PortInstance pi : this.getPorts()) {
            if (!(pi instanceof StartControlPortInstance)) continue;
            StartControlPortInstance scpi = (StartControlPortInstance)pi;
            LifeCycleManager.INSTANCE.activatePort((PortInstance)scpi);
        }
        return true;
    }

    private void tryActivateStartDataPort(StartDataPortInstance port) {
        if (port.getDataInstance() == null && port.getExecutionState() == State.INACTIVE) {
            return;
        }
        LifeCycleManager.INSTANCE.activatePort((PortInstance)port, port.getDataInstance());
    }

    @Override
    public void work() {
        this.returnValues = this.startParameter;
    }

    private void activateStartDataPortsWithParamter(Map<String, DataTypeInstance> parameters) {
        for (String s : parameters.keySet()) {
            for (PortInstance pi : this.getPorts()) {
                StartDataPortInstance sdpi;
                if (!(pi instanceof StartDataPortInstance) || !(sdpi = (StartDataPortInstance)pi).getDataInstance().getDataTypeType().getId().equals(s)) continue;
                DataTypeInstance dti = parameters.get(s);
                this.checkData(dti);
                LifeCycleManager.INSTANCE.activatePort((PortInstance)sdpi, dti);
            }
        }
    }

    private void checkData(DataTypeInstance dataTypeInstance) {
        if (dataTypeInstance.getDataTypeType() == null) {
            throw new IllegalArgumentException("At least one of the start parameters is not configured properly. The DataType is missing for " + dataTypeInstance.getName());
        }
    }

    public String getRunningForInstanceId() {
        return this.runningForInstanceId;
    }

    public void setRunningForInstanceId(String value) {
        this.runningForInstanceId = value;
    }
}

