/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.ListTypeInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.impl.custom.OpenHabSemanticInvokeInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.impl.custom.SofiaInstanceFactoryImplCustom;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import eu.vicci.process.model.util.JsonUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OpenHabSemanticResultSetReceiverInvokeInstanceImplCustom
extends OpenHabSemanticInvokeInstanceImplCustom {
    private Map<String, Integer> dataInstanceNumbers = new HashMap<String, Integer>();
    private boolean endportsAreActivated = false;
    protected String queryResult;

    @Override
    public void activateDataEndPorts() {
        if (this.endportsAreActivated) {
            this.LOGGER.warn("Endports already activated");
            return;
        }
        JsonObject resultObj = this.getResultObject();
        JsonArray vars = OpenHabSemanticResultSetReceiverInvokeInstanceImplCustom.getResultVars(resultObj);
        JsonArray bindings = OpenHabSemanticResultSetReceiverInvokeInstanceImplCustom.getResultsArray(resultObj);
        if (resultObj == null || vars == null || bindings == null) {
            this.LOGGER.error("cant get result object. enddataports are not activated");
            return;
        }
        List<EndDataPortInstance> settedPorts = this.iterateOverResultsAndSetPortValues(vars, bindings);
        for (EndDataPortInstance port : settedPorts) {
            LifeCycleManager.INSTANCE.activatePort((PortInstance)port);
        }
        this.endportsAreActivated = true;
    }

    private List<EndDataPortInstance> iterateOverResultsAndSetPortValues(JsonArray vars, JsonArray bindings) {
        ArrayList<EndDataPortInstance> settedPorts = new ArrayList<EndDataPortInstance>();
        for (int i = 0; i < bindings.size(); ++i) {
            JsonObject row = bindings.get(i).getAsJsonObject();
            this.addRowToListOfSpecificEndports(vars, row, settedPorts);
        }
        return settedPorts;
    }

    private void addRowToListOfSpecificEndports(JsonArray vars, JsonObject row, List<EndDataPortInstance> settedPorts) {
        for (int i = 0; i < vars.size(); ++i) {
            String varName = vars.get(i).getAsString();
            this.getPorts().stream().filter(port -> port instanceof EndDataPortInstance).map(port -> (EndDataPortInstance)port).forEach(port -> this.addToDataTypeInstance((EndDataPortInstance)port, varName, row, settedPorts));
        }
    }

    private void addToDataTypeInstance(EndDataPortInstance port, String varName, JsonObject row, List<EndDataPortInstance> settedPorts) {
        DataTypeInstance typeInstance = port.getDataInstance();
        if (!typeInstance.getDataTypeType().getName().equals(varName)) {
            return;
        }
        if (port.getDataInstance() instanceof ListTypeInstance) {
            this.addToListDataTypeInstance(port, varName, row, settedPorts);
            return;
        }
        if (settedPorts.contains(port)) {
            return;
        }
        JsonObject resultObj = row.get(varName).getAsJsonObject();
        String result = resultObj.get("value").getAsString();
        typeInstance.parse(result);
        settedPorts.add(port);
    }

    private void addToListDataTypeInstance(EndDataPortInstance port, String varName, JsonObject row, List<EndDataPortInstance> settedPorts) {
        ListTypeInstance data = (ListTypeInstance)port.getDataInstance();
        JsonObject resultObj = row.get(varName).getAsJsonObject();
        String result = resultObj.get("value").getAsString();
        DataTypeInstance typeInstance = this.getNewDataTypeInstance(data.getCollectionItemType());
        typeInstance.parse(result);
        data.getSubtypes().add((Object)typeInstance);
        if (!settedPorts.contains(port)) {
            settedPorts.add(port);
        }
    }

    private DataTypeInstance getNewDataTypeInstance(DataType collectionItemType) {
        if (collectionItemType == null) {
            throw new IllegalArgumentException("the collection item type of a list should not be null. Check the process model");
        }
        DataTypeInstance typeInstance = this.createDataTypeInstance(collectionItemType);
        String id = collectionItemType.getId();
        int instanceNumber = this.generateInstanceNumber(collectionItemType);
        typeInstance.setTypeId(id);
        typeInstance.setDataTypeType(collectionItemType);
        typeInstance.setName(collectionItemType.getName());
        typeInstance.setIdOfOrigin(id);
        typeInstance.setInstancenumber(instanceNumber);
        typeInstance.setInstanceId(id + "_Instance_" + instanceNumber);
        return typeInstance;
    }

    private int generateInstanceNumber(DataType collectionItemType) {
        String id = collectionItemType.getId();
        Integer out = this.dataInstanceNumbers.get(id);
        if (out == null) {
            out = 1;
        } else {
            Integer n = out;
            Integer n2 = out = Integer.valueOf(out + 1);
        }
        this.dataInstanceNumbers.put(id, out);
        return out;
    }

    private DataTypeInstance createDataTypeInstance(DataType collectionItemType) {
        int lio = collectionItemType.getClass().getSimpleName().lastIndexOf("Impl");
        if (lio < 0) {
            throw new IllegalArgumentException("can not find the correct factory method for " + collectionItemType.getClass().getSimpleName());
        }
        String split = collectionItemType.getClass().getSimpleName().substring(0, lio);
        String methodName = "create".concat(split).concat("Instance");
        DataTypeInstance instance = null;
        try {
            Method createMethod = SofiaInstanceFactoryImplCustom.class.getMethod(methodName, new Class[0]);
            Object result = createMethod.invoke((Object)SofiaInstanceFactoryImplCustom.getInstance(), new Object[0]);
            instance = (DataTypeInstance)result;
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("can not find the correct factory method for " + collectionItemType.getClass().getSimpleName());
        }
        return instance;
    }

    private JsonObject getResultObject() {
        if (this.queryResult == null || this.queryResult.isEmpty()) {
            return null;
        }
        JsonElement element = JsonUtil.parse(JsonElement.class, (String)this.queryResult);
        if (element == null || !element.isJsonObject()) {
            return null;
        }
        return element.getAsJsonObject();
    }

    private static JsonArray getResultVars(JsonObject resultObject) {
        if (resultObject == null) {
            return null;
        }
        JsonObject head = resultObject.get("head").getAsJsonObject();
        return head.get("vars").getAsJsonArray();
    }

    private static JsonArray getResultsArray(JsonObject resultObject) {
        if (resultObject == null) {
            return null;
        }
        JsonObject results = resultObject.get("results").getAsJsonObject();
        return results.get("bindings").getAsJsonArray();
    }
}

