/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import eu.vicci.openhab.util.IOpenHabRestClient;
import eu.vicci.openhab.util.OpenHabRestClient;
import eu.vicci.process.model.sofia.OpenHabSemanticInvoke;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.OpenHabSemanticInvokeInstance;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.util.configuration.ConfigurationManager;
import java.util.List;
import java.util.Optional;

public abstract class OpenHabSemanticInvokeInstanceImplCustom
extends ProcessStepInstanceImplCustom
implements OpenHabSemanticInvokeInstance {
    protected IOpenHabRestClient client;
    protected String serverBaseUri;
    protected String query;
    protected boolean withLatest;
    private static final String PLACEHOLDER_START = "<{";
    private static final String PLACEHOLDER_END = "}>";
    private static final String MISSING_END = "The given EPL statement contains the start tag for a placeholder but no endtag. Check the epl statement! \nStatement: '%s'";
    private static final String MISSING_VALUE = "A value for the placeholder name '%s' can not be found. The EPL statement wont compile!";

    protected boolean fillPrivateMembersAndStartClient(List<DataTypeInstance> startParameter) {
        if (!this.fillPrivateMembers(startParameter)) {
            return false;
        }
        this.client = new OpenHabRestClient(this.serverBaseUri);
        return true;
    }

    protected boolean fillPrivateMembers(List<DataTypeInstance> startParameter) {
        if (!(this.getProcessStepType() instanceof OpenHabSemanticInvoke)) {
            this.LOGGER.error("OpenHabSemanticInvoke cannot be mapped");
            return false;
        }
        OpenHabSemanticInvoke openhab = (OpenHabSemanticInvoke)this.getProcessStepType();
        this.serverBaseUri = ConfigurationManager.getInstance().getConfigAsString("OPENHAB_URI");
        this.query = OpenHabSemanticInvokeInstanceImplCustom.replacePlaceholder(openhab.getQuery(), startParameter);
        this.withLatest = openhab.isWithLatest();
        return true;
    }

    protected static String replacePlaceholder(String query, List<DataTypeInstance> startParameter) {
        if (!query.contains(PLACEHOLDER_START)) {
            return query;
        }
        int start = query.indexOf(PLACEHOLDER_START);
        int end = query.indexOf(PLACEHOLDER_END);
        if (end < 0) {
            throw new IllegalArgumentException(String.format(MISSING_END, query));
        }
        String name = query.substring(start + PLACEHOLDER_START.length(), end);
        String trimmedName = name.trim();
        Object value = OpenHabSemanticInvokeInstanceImplCustom.getValueForPlaceholder(trimmedName, startParameter);
        if (value == null) {
            throw new IllegalArgumentException(String.format(MISSING_VALUE, trimmedName));
        }
        String newEpl = query.replace(PLACEHOLDER_START + name + PLACEHOLDER_END, value.toString());
        return OpenHabSemanticInvokeInstanceImplCustom.replacePlaceholder(newEpl, startParameter);
    }

    private static Object getValueForPlaceholder(String name, List<DataTypeInstance> startParameter) {
        Optional<DataTypeInstance> valueHolder = startParameter.stream().filter(d -> d.getDataTypeType() != null && d.getDataTypeType() != null && d.getDataTypeType().getName().equals(name)).findFirst();
        if (valueHolder.isPresent()) {
            return valueHolder.get().getValueAsObject();
        }
        return null;
    }
}

