/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import eu.vicci.process.model.sofia.CollectionType;
import eu.vicci.process.model.sofia.ComplexType;
import eu.vicci.process.model.sofia.Condition;
import eu.vicci.process.model.sofia.DataPort;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.ForLoop;
import eu.vicci.process.model.sofia.If;
import eu.vicci.process.model.sofia.Loop;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofia.Transition;
import eu.vicci.process.model.sofiainstance.CollectionTypeInstance;
import eu.vicci.process.model.sofiainstance.ComplexTypeInstance;
import eu.vicci.process.model.sofiainstance.ConditionInstance;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.ExecutionPermission;
import eu.vicci.process.model.sofiainstance.ForLoopInstance;
import eu.vicci.process.model.sofiainstance.IfInstance;
import eu.vicci.process.model.sofiainstance.LoopInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.TransitionInstance;
import eu.vicci.process.model.sofiainstance.WhileLoopInstance;
import eu.vicci.process.model.sofiainstance.impl.MappingUtilImpl;
import eu.vicci.process.model.sofiainstance.impl.custom.DistributedProcessInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.impl.custom.DistributingProcessInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.impl.custom.SofiaInstanceFactoryImplCustom;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingUtilImplCustom
extends MappingUtilImpl {
    private final Logger LOGGER = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getSimpleName());
    private List<ProcessStepInstance> processStepInstances = new ArrayList<ProcessStepInstance>();
    private Set<PortInstance> portInstances = new HashSet<PortInstance>();
    private Set<TransitionInstance> transitionInstances = new HashSet<TransitionInstance>();
    private String processInstanceID = null;
    private String processModelID = null;
    private int instanceNumber;

    public ConditionInstance mapCondition(Condition condition) {
        ConditionInstance conditionInstance = null;
        try {
            String classname = condition.getClass().getSimpleName();
            int pos = classname.lastIndexOf("Impl");
            String tmp1 = classname.substring(0, pos);
            String classinstancename = tmp1 + "Instance";
            String factorymethod = "create" + classinstancename;
            Method method = null;
            method = ((Object)((Object)SofiaInstanceFactoryImplCustom.getInstance())).getClass().getMethod(factorymethod, new Class[0]);
            conditionInstance = (ConditionInstance)method.invoke((Object)SofiaInstanceFactoryImplCustom.getInstance(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return conditionInstance;
    }

    public PortInstance mapPort(Port port) {
        PortInstance portinstance = null;
        if (port == null) {
            return portinstance;
        }
        try {
            for (PortInstance p : this.portInstances) {
                if (!port.getId().equals(p.getPortType().getId())) continue;
                return p;
            }
            this.LOGGER.debug("Mapping Port: {}", (Object)port.getId());
            String classname = port.getClass().getSimpleName();
            int pos = classname.lastIndexOf("Impl");
            String tmp1 = classname.substring(0, pos);
            String classinstancename = tmp1 + "Instance";
            String factorymethod = "create" + classinstancename;
            Method method = null;
            method = ((Object)((Object)SofiaInstanceFactoryImplCustom.getInstance())).getClass().getMethod(factorymethod, new Class[0]);
            portinstance = (PortInstance)method.invoke((Object)SofiaInstanceFactoryImplCustom.getInstance(), new Object[0]);
            portinstance.setTypeId(port.getId());
            portinstance.setName(port.getName());
            if (portinstance instanceof DataPortInstance) {
                DataPortInstance dataPortInstance = (DataPortInstance)portinstance;
                DataPort dataPort = (DataPort)port;
                dataPortInstance.setDataInstance(this.mapDataType(dataPort.getPortDatatype()));
            }
            portinstance.setDecoupled(false);
            portinstance.setPortType(port);
            portinstance.setExecutionState(State.INACTIVE);
            portinstance.setInstancenumber(this.instanceNumber);
            portinstance.setInstanceId(port.getId() + "_Instance_" + portinstance.getInstancenumber());
            this.portInstances.add(portinstance);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return portinstance;
    }

    public TransitionInstance mapTransition(Transition transition) {
        for (TransitionInstance t : this.transitionInstances) {
            if (!transition.getId().equals(t.getTransitionType().getId())) continue;
            this.LOGGER.info("Transition already mapped! {}", (Object)transition.getId());
            return t;
        }
        TransitionInstance ti = SofiaInstanceFactoryImplCustom.getInstance().createTransitionInstance();
        ti.setTransitionType(transition);
        ti.setSourcePortInstance(this.mapPort(transition.getSourcePort()));
        ti.setTargetPortInstance(this.mapPort(transition.getTargetPort()));
        ti.setInstancenumber(this.instanceNumber);
        ti.setInstanceId(transition.getId() + "_Instance_" + this.instanceNumber);
        this.transitionInstances.add(ti);
        return ti;
    }

    public ProcessStepInstance mapProcessStep(ProcessStep processStep) {
        ProcessStepInstance psi = null;
        try {
            for (ProcessStepInstance instance : this.processStepInstances) {
                if (!instance.getProcessStepType().getId().equals(processStep.getId())) continue;
                return instance;
            }
            psi = this.createProcessStepInstance(processStep);
            psi.setProcessStepType(processStep);
            psi.setPermission(ExecutionPermission.GRANTED);
            psi.setProcessInstanceID(this.getProcessInstanceID());
            psi.setProcessModelID(this.getProcessModelID());
            psi.setInstancenumber(this.instanceNumber);
            psi.setInstanceId(psi.getProcessStepType().getId() + "_Instance_" + psi.getInstancenumber());
            psi.setCyberPhysical(processStep.isCyberPhysical());
            if (psi instanceof IfInstance) {
                this.mapIfInstance(processStep, psi);
            }
            if (psi instanceof ForLoopInstance) {
                this.mapForLoopInstance(processStep, psi);
            } else if (psi instanceof WhileLoopInstance) {
                this.mapWhileLoopInstance(processStep, psi);
            }
            this.processStepInstances.add(psi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return psi;
    }

    private ProcessStepInstance createProcessStepInstance(ProcessStep processStep) throws Exception {
        if (processStep instanceof Process) {
            return this.createProcessInstance((Process)processStep);
        }
        String classname = processStep.getClass().getSimpleName();
        int pos = classname.lastIndexOf("Impl");
        String tmp1 = classname.substring(0, pos);
        String classinstancename = tmp1 + "Instance";
        String factorymethod = "create" + classinstancename;
        Method method = ((Object)((Object)SofiaInstanceFactoryImplCustom.getInstance())).getClass().getMethod(factorymethod, new Class[0]);
        return (ProcessStepInstance)method.invoke((Object)SofiaInstanceFactoryImplCustom.getInstance(), new Object[0]);
    }

    private ProcessStepInstance createProcessInstance(Process process) {
        if (process.isRemoteExecuting()) {
            return new DistributedProcessInstanceImplCustom();
        }
        if (process.isDistributed()) {
            return new DistributingProcessInstanceImplCustom();
        }
        return new ProcessInstanceImplCustom();
    }

    private void mapWhileLoopInstance(ProcessStep processStep, ProcessStepInstance psi) {
        this.mapLoopInstance(processStep, psi);
    }

    private void mapLoopInstance(ProcessStep processStep, ProcessStepInstance psi) {
        Loop loop = (Loop)processStep;
        LoopInstance loopInstance = (LoopInstance)psi;
        ConditionInstance conditionInstance = this.getConditionInstance(loop.getLoopCondition());
        for (Map.Entry entry : loop.getPortsCopyToStartsport().entrySet()) {
            EndDataPortInstance key = (EndDataPortInstance)this.mapPort((Port)entry.getKey());
            StartDataPortInstance value = (StartDataPortInstance)this.mapPort((Port)entry.getValue());
            loopInstance.getPortsCopyToStartport().put((Object)key, (Object)value);
        }
        loopInstance.setLoopConditionInstance(conditionInstance);
        psi = loopInstance;
    }

    private void mapForLoopInstance(ProcessStep processStep, ProcessStepInstance psi) {
        this.mapLoopInstance(processStep, psi);
        ForLoop forLoop = (ForLoop)processStep;
        ForLoopInstance forLoopInstance = (ForLoopInstance)psi;
        forLoopInstance.setLoopStepWidth((StartDataPortInstance)this.mapPort((Port)forLoop.getLoopStepWidth()));
        psi = forLoopInstance;
    }

    private void mapIfInstance(ProcessStep processStep, ProcessStepInstance psi) {
        If ifStep = (If)processStep;
        IfInstance ifInstance = (IfInstance)psi;
        ConditionInstance conditionInstance = this.getConditionInstance(ifStep.getIfCondition());
        ifInstance.setIfConditionInstance(conditionInstance);
        psi = ifInstance;
    }

    private ConditionInstance getConditionInstance(Condition condition) {
        ConditionInstance conditionInstance = this.mapCondition(condition);
        conditionInstance.setLeftSide((StartDataPortInstance)this.mapPort((Port)condition.getLeftSide()));
        conditionInstance.setRightSide((StartDataPortInstance)this.mapPort((Port)condition.getRightSide()));
        conditionInstance.setIfConditionType(condition);
        return conditionInstance;
    }

    public DataTypeInstance mapDataType(DataType dataType) {
        DataTypeInstance dataTypeinstance = null;
        try {
            String classname = dataType.getClass().getSimpleName();
            int pos = classname.lastIndexOf("Impl");
            String tmp1 = classname.substring(0, pos);
            String classinstancename = tmp1 + "Instance";
            String factorymethod = "create" + classinstancename;
            Method method = null;
            method = ((Object)((Object)SofiaInstanceFactoryImplCustom.getInstance())).getClass().getMethod(factorymethod, new Class[0]);
            dataTypeinstance = (DataTypeInstance)method.invoke((Object)SofiaInstanceFactoryImplCustom.getInstance(), new Object[0]);
            dataTypeinstance.setTypeId(dataType.getId());
            dataTypeinstance.setDataTypeType(dataType);
            dataTypeinstance.setName(dataType.getName());
            dataTypeinstance.setIdOfOrigin(dataType.getId());
            dataTypeinstance.setInstancenumber(this.instanceNumber);
            dataTypeinstance.setInstanceId(dataType.getId() + "_Instance_" + dataTypeinstance.getInstancenumber());
            if (dataType instanceof CollectionType) {
                CollectionType collt = (CollectionType)dataType;
                CollectionTypeInstance collti = (CollectionTypeInstance)dataTypeinstance;
                DataType colldti = collt.getCollectionItemType();
                DataType colldtiCopy = (DataType)EcoreUtil.copy((EObject)colldti);
                collti.setCollectionItemType(colldtiCopy);
            }
            if (dataType instanceof ComplexType) {
                ComplexType ct = (ComplexType)dataType;
                for (DataType dt : ct.getSubtypes()) {
                    if (!(dataTypeinstance instanceof ComplexTypeInstance)) continue;
                    ComplexTypeInstance cti = (ComplexTypeInstance)dataTypeinstance;
                    cti.getSubtypes().add((Object)this.mapDataType(dt));
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return dataTypeinstance;
    }

    private String getProcessInstanceID() {
        if (this.processInstanceID == null) {
            for (ProcessStepInstance psi : this.processStepInstances) {
                ProcessInstance pi = null;
                if (psi instanceof ProcessInstance) {
                    pi = (ProcessInstance)psi;
                }
                this.processInstanceID = pi.getInstanceId();
            }
        }
        return this.processInstanceID;
    }

    private String getProcessModelID() {
        if (this.processModelID == null) {
            for (ProcessStepInstance psi : this.processStepInstances) {
                ProcessInstance pi = null;
                if (psi instanceof ProcessInstance) {
                    pi = (ProcessInstance)psi;
                }
                this.processModelID = pi.getProcessStepType().getId();
            }
        }
        this.setProcessModelID(this.processModelID);
        return this.processModelID;
    }

    public void setProcessStepInstances(List<ProcessStepInstance> processStepInstances) {
        this.processStepInstances = processStepInstances;
    }

    public void setPortInstances(Set<PortInstance> portInstances) {
        this.portInstances = portInstances;
    }

    public void setTransitionInstances(Set<TransitionInstance> transitionInstances) {
        this.transitionInstances = transitionInstances;
    }

    public void setProcessInstanceID(String processInstanceID) {
        this.processInstanceID = processInstanceID;
    }

    public void setProcessModelID(String processModelID) {
        this.processModelID = processModelID;
    }

    public void setInstanceNumber(int number) {
        this.instanceNumber = number;
    }
}

