/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import eu.vicci.process.model.sofiainstance.ConditionInstance;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.EndPortInstance;
import eu.vicci.process.model.sofiainstance.EscalationPortInstance;
import eu.vicci.process.model.sofiainstance.LoopInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;

public abstract class LoopInstanceImplCustomBase
extends ProcessStepInstanceImplCustom
implements LoopInstance {
    protected ConditionInstance loopConditionInstance;
    protected boolean resetRequested = false;
    protected EMap<EndDataPortInstance, StartDataPortInstance> portsCopyToStartport = new BasicEMap();

    @Override
    public boolean onExecute() {
        this.logInfo("-------------> execution started");
        this.cancelTimer();
        this.aggregateStartParameter();
        this.aggregateEndParameter();
        this.startStateTimerIfNeeded();
        if (this.anyEndPortsWhichRequiresWaiting()) {
            this.changeEndPortStates(State.WAITING);
        } else {
            this.work();
        }
        return true;
    }

    @Override
    public void preReset() {
        this.resetRequested = true;
        super.preReset();
    }

    @Override
    public void portExecutionStateChanged(PortInstance port) {
        switch (port.getExecutionState()) {
            case WAITING: {
                if (!this.allEndPortsHaveTheState(State.WAITING)) break;
                this.work();
                break;
            }
            case INACTIVE: {
                if (!this.allEndPortsHaveTheState(State.INACTIVE)) break;
                this.doingEndoperations();
                super.portExecutionStateChanged(port);
                break;
            }
            default: {
                super.portExecutionStateChanged(port);
            }
        }
    }

    protected boolean doLoopStep() {
        if (!this.loopConditionInstance.evaluate()) {
            return false;
        }
        this.startSubProcesses();
        return true;
    }

    @Override
    public abstract void work();

    public ConditionInstance getLoopConditionInstance() {
        return this.loopConditionInstance;
    }

    public void setLoopConditionInstance(ConditionInstance value) {
        this.loopConditionInstance = value;
    }

    public EMap<EndDataPortInstance, StartDataPortInstance> getPortsCopyToStartport() {
        return this.portsCopyToStartport;
    }

    protected boolean performNextStepIfPossible() {
        if (!this.allSubstepsAreReset() || !this.loopConditionInstance.evaluate()) {
            return false;
        }
        this.checkArgs();
        return this.doLoopStep();
    }

    protected abstract void checkArgs();

    protected void changeEndPortStates(State newState) {
        this.getPorts().stream().filter(p -> p instanceof EndPortInstance && !(p instanceof EscalationPortInstance)).forEach(p -> LifeCycleManager.INSTANCE.changePortExecutionState((PortInstance)p, newState));
    }

    protected void copyEndDataPortValuesToStartDataPorts() {
        DataTypeInstance dataTypeInstance = null;
        for (Map.Entry entry : this.portsCopyToStartport) {
            dataTypeInstance = ((EndDataPortInstance)entry.getKey()).getDataInstance();
            LifeCycleManager.INSTANCE.setPortDataTypeInstanceSync((DataPortInstance)entry.getValue(), dataTypeInstance.copy());
        }
    }

    private boolean anyEndPortsWhichRequiresWaiting() {
        return this.getPorts().stream().anyMatch(p -> p instanceof EndPortInstance && !(p instanceof EscalationPortInstance));
    }

    @Override
    public void activateDataEndPorts() {
        if (!this.returnValues.isEmpty()) {
            super.activateDataEndPorts();
        }
        this.getPorts().stream().filter(port -> port instanceof EndDataPortInstance).forEach(port -> LifeCycleManager.INSTANCE.activatePortSync((PortInstance)port, ((EndDataPortInstance)port).getDataInstance()));
    }
}

