/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import akka.actor.ActorRef;
import eu.vicci.process.model.implementations.internal.Activator;
import eu.vicci.process.model.sofia.impl.LoadClassStepImpl;
import eu.vicci.process.model.sofiainstance.LoadClassStepInstance;
import eu.vicci.process.model.sofiainstance.MappingUtil;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.util.processstepclasses.ProcessStepWorker;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.osgi.framework.Bundle;

public class LoadClassStepInstanceImplCustom
extends ProcessStepInstanceImplCustom
implements LoadClassStepInstance {
    private static final String classLoc = "./processDirectories/aProcessDir/classes/";
    private ProcessStepWorker processStepWorker = null;
    private String delegateName = null;

    @Override
    public void onDeploy(MappingUtil mapper, ActorRef parent) {
        boolean runInOSGI;
        super.onDeploy(mapper, parent);
        this.delegateName = ((LoadClassStepImpl)this.getProcessStepType()).getDelegateClassName();
        boolean bl = runInOSGI = Activator.getDefault() != null;
        if (runInOSGI) {
            if (!this.tryLoadFromBundles()) {
                this.throwClassNotFound();
            }
        } else if (!this.tryLoadLocal()) {
            this.throwClassNotFound();
        }
        this.processStepWorker.deploy();
    }

    @Override
    public void work() {
        ProcessStepWorker.Context context = new ProcessStepWorker.Context();
        context.startParameter = this.startParameter;
        context.endParameter = this.endParameter;
        context.instanceId = this.getInstanceId();
        this.returnValues = this.processStepWorker.work(context);
    }

    private ClassLoader getClassLoader() {
        File file = new File(classLoc);
        URL[] urls = null;
        try {
            URL url = file.toURI().toURL();
            urls = new URL[]{url};
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (urls == null) {
            return this.getClass().getClassLoader();
        }
        return new URLClassLoader(urls);
    }

    private boolean tryLoadFromBundles() {
        for (Bundle bundle : Activator.getDefault().getContext().getBundles()) {
            try {
                this.processStepWorker = (ProcessStepWorker)bundle.loadClass(this.delegateName).newInstance();
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean tryLoadLocal() {
        ClassLoader cl = this.getClassLoader();
        try {
            this.processStepWorker = (ProcessStepWorker)Class.forName(this.delegateName, true, cl).newInstance();
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            return false;
        }
    }

    private void throwClassNotFound() {
        throw new IllegalStateException("Process Step Worker with delegate '" + this.delegateName + "' cannot be found.");
    }
}

