/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import com.google.gson.Gson;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.impl.IntegerTypeInstanceImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IntegerTypeInstanceImplCustom
extends IntegerTypeInstanceImpl {
    public DataTypeInstance copy() {
        IntegerTypeInstanceImplCustom newIntegerTypeInstance = new IntegerTypeInstanceImplCustom();
        newIntegerTypeInstance.setValue(this.value);
        newIntegerTypeInstance.setTypeId(this.getTypeId());
        newIntegerTypeInstance.setDataTypeType(this.getDataTypeType());
        newIntegerTypeInstance.setInstanceId(UUID.randomUUID().toString());
        newIntegerTypeInstance.setName(this.getName());
        return newIntegerTypeInstance;
    }

    public void parse(String text) {
        this.value = new Integer(text);
    }

    public String serializeToXML() {
        String xml = "";
        if (this.getDataTypeType().getBelongsTo() == null) {
            xml = "<?xml version='1.0' encoding='UTF-8'?>";
        }
        xml = xml + "<" + this.getDataTypeType().getName() + ">" + this.getValue() + "</" + this.getDataTypeType().getName() + ">";
        return xml;
    }

    public boolean deserializeFromXML(String xmlInstance) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream inStreamTemp = new ByteArrayInputStream(xmlInstance.getBytes());
            InputSource inputSourceTemp = new InputSource(inStreamTemp);
            Document dataTypeDOM = db.parse(inputSourceTemp);
            String nodeName = dataTypeDOM.getFirstChild().getNodeName();
            String localName = this.getDataTypeType().getName();
            if (!localName.equals(nodeName)) {
                return false;
            }
            this.parse(dataTypeDOM.getFirstChild().getTextContent());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void createDummyData() {
        this.parse(new Integer(Double.toString(Math.random() * 1000.0)).toString());
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public String serializeToJSON() {
        String json = "'" + this.getDataTypeType().getName() + "': " + this.getValue();
        json = json.replace("'", "\"");
        return json;
    }

    public boolean deserializeFromJSON(String jsonString) {
        int pos2;
        boolean success = false;
        int pos = jsonString.indexOf("\"") + 1;
        String name = jsonString.substring(pos, pos2 = jsonString.indexOf(":") - 1);
        if (name.equals(this.getDataTypeType().getName())) {
            int value;
            success = true;
            Gson gson = new Gson();
            this.value = value = ((Integer)gson.fromJson(jsonString, Integer.class)).intValue();
        }
        return success;
    }

    public Integer getValueAsObject() {
        return this.value;
    }

    public void setValueFromString(String value) {
        this.value = Integer.parseInt(value);
    }

    public int compareTo(EObject o) {
        IntegerTypeInstance other = (IntegerTypeInstance)o;
        return this.getValueAsObject().compareTo(other.getValue());
    }
}

