/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import eu.vicci.process.model.sofia.FalseTransition;
import eu.vicci.process.model.sofia.TrueTransition;
import eu.vicci.process.model.sofiainstance.ConditionInstance;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndControlPortInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.IfInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.TransitionInstance;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;

public class IfInstanceImplCustom
extends ProcessStepInstanceImplCustom
implements IfInstance {
    private Boolean conditionEvaluationResult = false;
    private ConditionInstance conditionInstance;

    @Override
    public void work() {
        ConditionInstance ci = this.getIfConditionInstance();
        this.conditionEvaluationResult = ci.evaluate();
        this.returnValues = this.startParameter;
    }

    @Override
    public void activateDataEndPorts() {
        this.getPorts().stream().filter(port -> port instanceof EndDataPortInstance).forEach(port -> this.activateOrDeactivateDataEndPort((PortInstance)port));
    }

    @Override
    public void activateControlEndPorts() {
        this.getPorts().stream().filter(port -> port instanceof EndControlPortInstance).forEach(port -> this.activateOrDeactivateControlEndPort((PortInstance)port));
    }

    public ConditionInstance getIfConditionInstance() {
        return this.conditionInstance;
    }

    public void setIfConditionInstance(ConditionInstance value) {
        this.conditionInstance = value;
    }

    @Override
    public void forwardReactivation() {
    }

    private void activateOrDeactivateDataEndPort(PortInstance port) {
        if (port.getOutTransitionInstances().isEmpty()) {
            LifeCycleManager.INSTANCE.deactivatePort(port);
            return;
        }
        TransitionInstance transitionInstance = (TransitionInstance)port.getOutTransitionInstances().get(0);
        if (this.conditionEvaluationResult.booleanValue() && transitionInstance instanceof TrueTransition || !this.conditionEvaluationResult.booleanValue() && transitionInstance instanceof FalseTransition) {
            this.activateDataEndPort(port);
        } else {
            LifeCycleManager.INSTANCE.deactivatePort(port);
        }
    }

    private void activateDataEndPort(PortInstance port) {
        DataPortInstance port1 = (DataPortInstance)port;
        for (DataTypeInstance dataInstance : this.returnValues) {
            String wantedDataId;
            String dataId = dataInstance.getDataTypeType().getName();
            if (!dataId.equals(wantedDataId = port1.getDataInstance().getDataTypeType().getName())) continue;
            LifeCycleManager.INSTANCE.activatePortSync(port, dataInstance);
        }
    }

    private void activateOrDeactivateControlEndPort(PortInstance port) {
        if (port.getOutTransitionInstances().size() <= 0) {
            LifeCycleManager.INSTANCE.deactivatePort(port);
            return;
        }
        TransitionInstance transitionInstance = (TransitionInstance)port.getOutTransitionInstances().get(0);
        if (this.conditionEvaluationResult.booleanValue() && transitionInstance.getTransitionType() instanceof TrueTransition || !this.conditionEvaluationResult.booleanValue() && transitionInstance.getTransitionType() instanceof FalseTransition) {
            LifeCycleManager.INSTANCE.activatePortSync(port);
        } else {
            LifeCycleManager.INSTANCE.deactivatePort(port);
        }
    }
}

