/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import akka.actor.ActorRef;
import eu.vicci.process.actors.ActorAssignable;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.MappingUtil;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.TransitionInstance;
import eu.vicci.process.model.sofiainstance.impl.EscalationPortInstanceImpl;
import eu.vicci.process.model.sofiainstance.states.PortExecutionStateChangedListener;
import eu.vicci.process.model.sofiainstance.states.PortExecutionStateListenable;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import eu.vicci.process.model.sofiainstance.util.PortUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscalationPortInstanceImplCustom
extends EscalationPortInstanceImpl
implements ActorAssignable,
PortExecutionStateListenable {
    private final Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private final List<PortExecutionStateChangedListener> listeners = new ArrayList<PortExecutionStateChangedListener>();
    private ActorRef actorReference = null;
    private volatile State executionState = State.INACTIVE;

    public void deploy(MappingUtil mapper) {
        this.deploy(mapper, null);
    }

    @Override
    public void deploy(MappingUtil mapper, ActorRef parent) {
        this.actorReference = LifeCycleManager.INSTANCE.createActorForEndPortSync((PortInstance)this, parent);
        PortUtil.deploy((PortInstance)this, mapper, this.actorReference);
    }

    public boolean activate(DataTypeInstance parameter) {
        if (this.executionState == State.ACTIVE || this.executionState == State.DEACTIVATED) {
            return true;
        }
        this.changeExecutionStateAndInformListeners(State.ACTIVE);
        this.LOGGER.debug("{}.activate()", (Object)this.getPortType().getName());
        this.setInstanceId("EscalationPort " + this.getPortType().getName() + "_instance_" + this.getInstancenumber());
        for (TransitionInstance t : this.getOutTransitionInstances()) {
            LifeCycleManager.INSTANCE.executeTransition(t);
        }
        return true;
    }

    public void deactivate() {
        if (this.executionState == State.ACTIVE || this.executionState == State.DEACTIVATED) {
            return;
        }
        this.changeExecutionStateAndInformListeners(State.DEACTIVATED);
        this.LOGGER.debug("{}.deactivate()", (Object)this.getPortType().getName());
        this.setInstanceId("EscalationPort " + this.getPortType().getName() + "_instance_" + this.getInstancenumber());
        for (TransitionInstance t : this.getOutTransitionInstances()) {
            LifeCycleManager.INSTANCE.deactivateTransition(t);
        }
    }

    public void setExecutionState(State newExecutionState) {
        this.executionState = newExecutionState;
    }

    public State getExecutionState() {
        return this.executionState;
    }

    @Override
    public ActorRef getActorReference() {
        return this.actorReference;
    }

    @Override
    public void addPortExecutionStateChangedListener(PortExecutionStateChangedListener listener) {
        this.listeners.add(listener);
    }

    private void changeExecutionStateAndInformListeners(State newState) {
        this.executionState = newState;
        for (PortExecutionStateChangedListener listener : this.listeners) {
            LifeCycleManager.INSTANCE.portExecutionStateChanged(listener, (PortInstance)this);
        }
    }
}

