/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import akka.actor.ActorRef;
import eu.vicci.process.actors.ActorAssignable;
import eu.vicci.process.model.sofia.impl.DataPortImpl;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.MappingUtil;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.TransitionInstance;
import eu.vicci.process.model.sofiainstance.impl.EndDataPortInstanceImpl;
import eu.vicci.process.model.sofiainstance.states.PortExecutionStateChangedListener;
import eu.vicci.process.model.sofiainstance.states.PortExecutionStateListenable;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import eu.vicci.process.model.sofiainstance.util.PortUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndDataPortInstanceImplCustom
extends EndDataPortInstanceImpl
implements ActorAssignable,
PortExecutionStateListenable {
    private final Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private final List<PortExecutionStateChangedListener> listeners = new ArrayList<PortExecutionStateChangedListener>();
    private ActorRef actorReference = null;
    protected volatile State executionState = State.INACTIVE;

    public void deploy(MappingUtil mapper) {
        this.deploy(mapper, null);
    }

    @Override
    public void deploy(MappingUtil mapper, ActorRef parent) {
        String presetValue;
        this.actorReference = LifeCycleManager.INSTANCE.createActorForEndPortSync((PortInstance)this, parent);
        PortUtil.deploy((PortInstance)this, mapper, this.actorReference);
        DataPortImpl dataPort = (DataPortImpl)this.getPortType();
        if (dataPort.getPortDatatype() != null) {
            this.dataInstance = mapper.mapDataType(dataPort.getPortDatatype());
        }
        if ((presetValue = dataPort.getValue()) != null && !presetValue.isEmpty()) {
            this.dataInstance.parse(presetValue);
        }
    }

    public boolean activate(DataTypeInstance parameter) {
        switch (this.executionState) {
            case INACTIVE: {
                return this.performActivate(parameter);
            }
            case WAITING: {
                this.setParameterAsDataInstance(parameter);
                return true;
            }
        }
        return true;
    }

    public void deactivate() {
        if (this.executionState == State.ACTIVE || this.executionState == State.DEACTIVATED) {
            return;
        }
        this.setExecutionState(State.DEACTIVATED);
        this.LOGGER.debug("{}.deactivate()", (Object)this.getPortType().getName());
        this.setInstanceId("EndDataPort " + this.getPortType().getName() + "_instance_" + this.getInstancenumber());
        for (TransitionInstance t : this.getOutTransitionInstances()) {
            LifeCycleManager.INSTANCE.deactivateTransition(t);
        }
    }

    public void setDataInstance(DataTypeInstance newDataInstance) {
        this.dataInstance = newDataInstance;
    }

    public DataTypeInstance getDataInstance() {
        return this.dataInstance;
    }

    @Override
    public ActorRef getActorReference() {
        return this.actorReference;
    }

    @Override
    public void addPortExecutionStateChangedListener(PortExecutionStateChangedListener listener) {
        this.listeners.add(listener);
    }

    public void setExecutionState(State newExecutionState) {
        this.executionState = newExecutionState;
        this.informListeners();
    }

    public State getExecutionState() {
        return this.executionState;
    }

    private boolean performActivate(DataTypeInstance parameter) {
        this.setParameterAsDataInstance(parameter);
        this.LOGGER.debug("{}.activate()", (Object)this.getPortType().getName());
        this.setInstanceId("EndDataPort " + this.getPortType().getName() + "_instance_" + this.getInstancenumber());
        for (TransitionInstance t : this.getOutTransitionInstances()) {
            LifeCycleManager.INSTANCE.executeTransitionSync(t, this.dataInstance.copy());
        }
        this.setExecutionState(State.ACTIVE);
        return true;
    }

    private void setParameterAsDataInstance(DataTypeInstance parameter) {
        if (parameter != null) {
            this.dataInstance = parameter;
        }
    }

    private void informListeners() {
        for (PortExecutionStateChangedListener listener : this.listeners) {
            LifeCycleManager.INSTANCE.portExecutionStateChanged(listener, (PortInstance)this);
        }
    }
}

