/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import com.google.gson.Gson;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.DoubleTypeInstance;
import eu.vicci.process.model.sofiainstance.impl.DoubleTypeInstanceImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DoubleTypeInstanceImplCustom
extends DoubleTypeInstanceImpl {
    public DataTypeInstance copy() {
        DoubleTypeInstanceImplCustom newDoubleTypeInstance = new DoubleTypeInstanceImplCustom();
        newDoubleTypeInstance.setValue(this.value);
        newDoubleTypeInstance.setTypeId(this.getTypeId());
        newDoubleTypeInstance.setDataTypeType(this.getDataTypeType());
        newDoubleTypeInstance.setInstanceId(UUID.randomUUID().toString());
        return newDoubleTypeInstance;
    }

    public void parse(String text) {
        this.value = new Double(text);
    }

    public String serializeToXML() {
        String xml = "";
        if (this.getDataTypeType().getBelongsTo() == null) {
            xml = "<?xml version='1.0' encoding='UTF-8'?>";
        }
        xml = xml + "<" + this.getDataTypeType().getName() + ">" + this.getValue() + "</" + this.getDataTypeType().getName() + ">";
        return xml;
    }

    public boolean deserializeFromXML(String xmlInstance) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream inStreamTemp = new ByteArrayInputStream(xmlInstance.getBytes());
            InputSource inputSourceTemp = new InputSource(inStreamTemp);
            Document dataTypeDOM = db.parse(inputSourceTemp);
            String nodeName = dataTypeDOM.getFirstChild().getNodeName();
            String localName = this.getDataTypeType().getName();
            if (!localName.equals(nodeName)) {
                return false;
            }
            this.parse(dataTypeDOM.getFirstChild().getTextContent());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void createDummyData() {
        this.parse(Double.toString(Math.random() * 1000.0));
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public String serializeToJSON() {
        String json = "'" + this.getDataTypeType().getName() + "': " + this.getValue();
        json = json.replace("'", "\"");
        return json;
    }

    public boolean deserializeFromJSON(String jsonString) {
        int pos2;
        boolean success = false;
        int pos = jsonString.indexOf("\"") + 1;
        String name = jsonString.substring(pos, pos2 = jsonString.indexOf(":") - 1);
        if (name.equals(this.getDataTypeType().getName())) {
            success = true;
            Gson gson = new Gson();
            Double value = (Double)gson.fromJson(jsonString, Double.class);
            this.value = value;
        }
        return success;
    }

    public Double getValueAsObject() {
        return this.value;
    }

    public void setValueFromString(String value) {
        this.value = Double.parseDouble(value);
    }

    public int compareTo(EObject o) {
        DoubleTypeInstance other = (DoubleTypeInstance)o;
        return this.getValueAsObject().compareTo(other.getValue());
    }
}

