/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import eu.vicci.process.distribution.core.IDistributionManager;
import eu.vicci.process.distribution.manager.DistributionManager;
import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.DoubleTypeInstance;
import eu.vicci.process.model.sofiainstance.EndControlPortInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import eu.vicci.process.model.sofiainstance.util.RemoteStepInvokeWorker;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONDataPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONPortInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONTypeInstance;

public class DistributingProcessInstanceImplCustom
extends ProcessInstanceImplCustom {
    private RemoteStepInvokeWorker worker;
    private IDistributionManager distributionManager = DistributionManager.getInstance();
    private static final String ERR_MISS_PORT_OR_CUR = "Cant activate or deactivate EndDataPort. Port is missing on peer side or data received is corrupt";
    private static final String ERR_DIFF_DT = "Different Type Id on data received from remote peer";
    private static final String ERR_PEER_MISS_PORT = "Cant activate or deactivate EndControlPort. Port is missing on peer side.";
    private static final String ERR_NO_DIST_MGR = "no DistributionManager available. Cant remote execute process. At the moment no option implemented to execute the process local in this case";

    @Override
    public boolean onExecute() {
        this.LOGGER.debug("Distributed Process Step, start remote execution");
        if (this.distributionManager == null) {
            throw new IllegalArgumentException(ERR_NO_DIST_MGR);
        }
        this.worker = new RemoteStepInvokeWorker(this, this.distributionManager);
        this.worker.work();
        this.doingEndoperations();
        return this.worker.receivedFinalMessage();
    }

    @Override
    public boolean allSubstepsHasFinishedExecution() {
        return true;
    }

    public void setDistributionManager(IDistributionManager distributionManager) {
        this.distributionManager = distributionManager;
    }

    public void finishDistribution() {
        this.worker.forceFinish();
    }

    @Override
    public void activateDataEndPorts() {
        if (!this.worker.receivedFinalMessage()) {
            return;
        }
        this.getPorts().stream().filter(p -> p instanceof EndDataPortInstance).forEach(p -> this.activateEndDataPort((EndDataPortInstance)p));
    }

    @Override
    public void activateControlEndPorts() {
        if (!this.worker.receivedFinalMessage()) {
            return;
        }
        this.getPorts().stream().filter(p -> p instanceof EndControlPortInstance).forEach(p -> this.activateEndControlPort((EndControlPortInstance)p));
    }

    private void activateEndControlPort(EndControlPortInstance port) {
        IJSONPortInstance remote = this.worker.getEndControlPorts().get(port.getPortType().getId());
        this.checkControl(remote);
        if (remote.getExecutionState() == State.ACTIVE) {
            LifeCycleManager.INSTANCE.activatePortSync((PortInstance)port);
        } else {
            LifeCycleManager.INSTANCE.deactivatePort((PortInstance)port);
        }
    }

    private void checkControl(IJSONPortInstance remote) {
        if (remote == null) {
            throw new RuntimeException(ERR_PEER_MISS_PORT);
        }
    }

    private void activateEndDataPort(EndDataPortInstance port) {
        IJSONDataPortInstance remote = this.worker.getEndDataPorts().get(port.getPortType().getId());
        this.checkData(port.getDataInstance(), remote);
        if (remote.getExecutionState() == State.ACTIVE) {
            this.safeValueSetting(port.getDataInstance(), remote.getDataTypeInstance());
            LifeCycleManager.INSTANCE.activatePortSync((PortInstance)port, port.getDataInstance());
        } else {
            LifeCycleManager.INSTANCE.deactivatePort((PortInstance)port);
        }
    }

    private void checkData(DataTypeInstance original, IJSONDataPortInstance remote) {
        if (remote == null || remote.getDataTypeInstance() == null || remote.getDataTypeInstance().getDataType() == null || remote.getDataTypeInstance().getDataType().getID() == null) {
            throw new RuntimeException(ERR_MISS_PORT_OR_CUR);
        }
        if (!original.getDataTypeType().getId().equals(remote.getDataTypeInstance().getDataType().getID())) {
            throw new RuntimeException(ERR_DIFF_DT);
        }
    }

    private void safeValueSetting(DataTypeInstance original, IJSONTypeInstance remote) {
        if (original instanceof StringTypeInstance) {
            ((StringTypeInstance)original).setValue((String)remote.getValueAsObject());
        } else if (original instanceof DoubleTypeInstance) {
            ((DoubleTypeInstance)original).setValue(((Double)remote.getValueAsObject()).doubleValue());
        } else if (original instanceof IntegerTypeInstance) {
            ((IntegerTypeInstance)original).setValue(((Integer)remote.getValueAsObject()).intValue());
        } else if (original instanceof BooleanTypeInstance) {
            ((BooleanTypeInstance)original).setValue(((Boolean)remote.getValueAsObject()).booleanValue());
        } else {
            throw new RuntimeException("Not supported DataTypeInstance for remote processing. Class: " + original.getClass().getSimpleName());
        }
    }
}

