/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import eu.vicci.process.model.sofia.DataMapping;
import eu.vicci.process.model.sofia.EndDataPort;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofiainstance.ComplexTypeInstance;
import eu.vicci.process.model.sofiainstance.DataMappingStepInstance;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DataMappingStepInstanceImplCustom
extends ProcessStepInstanceImplCustom
implements DataMappingStepInstance {
    @Override
    public void work() {
        LinkedList<DataPortInstance> startDataPorts = new LinkedList<DataPortInstance>();
        LinkedList<DataPortInstance> endDataPorts = new LinkedList<DataPortInstance>();
        for (PortInstance port : this.getPorts()) {
            DataPortInstance dataPortInstance;
            if (port instanceof StartDataPortInstance) {
                dataPortInstance = (DataPortInstance)port;
                System.out.println(dataPortInstance.getDataInstance().serializeToXML());
                startDataPorts.add(dataPortInstance);
                continue;
            }
            if (!(port instanceof EndDataPortInstance)) continue;
            dataPortInstance = (DataPortInstance)port;
            endDataPorts.add(dataPortInstance);
        }
        HashSet<DataMapping> allMappings = new HashSet<DataMapping>();
        allMappings.addAll(this.getAllDataMappings(startDataPorts));
        allMappings.addAll(this.getAllDataMappings(endDataPorts));
        for (DataPortInstance edpi : endDataPorts) {
            DataTypeInstance finalDataTypeInstance = this.mapp(startDataPorts, allMappings, edpi.getDataInstance());
            edpi.setDataInstance(finalDataTypeInstance);
        }
    }

    private DataTypeInstance getDataTypeInstanceByDataTypeId(String id, DataTypeInstance dti) {
        if (dti.getDataTypeType().getId().equals(id)) {
            return dti;
        }
        if (dti instanceof ComplexTypeInstance) {
            ComplexTypeInstance ct = (ComplexTypeInstance)dti;
            for (DataTypeInstance dataTypeInstance : ct.getSubtypes()) {
                DataTypeInstance d = this.getDataTypeInstanceByDataTypeId(id, dataTypeInstance);
                if (d == null) continue;
                return d;
            }
        }
        return null;
    }

    private Set<DataMapping> getAllDataMappings(Collection<DataPortInstance> pis) {
        HashSet<DataMapping> allMappings = new HashSet<DataMapping>();
        for (DataPortInstance dpi : pis) {
            Port p = dpi.getPortType();
            if (!(p instanceof EndDataPort)) continue;
            EndDataPort edp = (EndDataPort)p;
            allMappings.addAll((Collection<DataMapping>)edp.getMappings());
        }
        return allMappings;
    }

    private DataTypeInstance mapp(List<DataPortInstance> startDataPorts, Set<DataMapping> allMappings, DataTypeInstance dataTypeInstance) {
        for (DataMapping dm : allMappings) {
            String sourceId = dm.getTarget().getId();
            String targetId = dm.getSource().getId();
            for (DataPortInstance sdpi : startDataPorts) {
                DataTypeInstance dtiSource = this.getDataTypeInstanceByDataTypeId(sourceId, sdpi.getDataInstance());
                if (dtiSource == null) continue;
                DataTypeInstance dtiTarget = this.getDataTypeInstanceByDataTypeId(targetId, dataTypeInstance);
                String classSource = dtiSource.getClass().getSimpleName();
                String classTarget = dtiTarget.getClass().getSimpleName();
                if (dtiTarget == null || !classSource.equals(classTarget)) continue;
                dtiTarget.parse(dtiSource.toString());
            }
        }
        return dataTypeInstance;
    }
}

