/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.impl.custom;

import com.google.gson.Gson;
import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.impl.BooleanTypeInstanceImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BooleanTypeInstanceImplCustom
extends BooleanTypeInstanceImpl {
    public DataTypeInstance copy() {
        BooleanTypeInstanceImplCustom newBooleanTypeInstance = new BooleanTypeInstanceImplCustom();
        newBooleanTypeInstance.setValue(this.value);
        newBooleanTypeInstance.setTypeId(this.getTypeId());
        newBooleanTypeInstance.setDataTypeType(this.getDataTypeType());
        newBooleanTypeInstance.setInstanceId(UUID.randomUUID().toString());
        return newBooleanTypeInstance;
    }

    public void parse(String text) {
        this.value = new Boolean(text);
    }

    public String serializeToXML() {
        String xml = "";
        if (this.getDataTypeType().getBelongsTo() == null) {
            xml = "<?xml version='1.0' encoding='UTF-8'?>";
        }
        xml = xml + "<" + this.getDataTypeType().getName() + ">" + this.value + "</" + this.getDataTypeType().getName() + ">";
        return xml;
    }

    public boolean deserializeFromXML(String xmlInstance) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream inStreamTemp = new ByteArrayInputStream(xmlInstance.getBytes());
            InputSource inputSourceTemp = new InputSource(inStreamTemp);
            Document dataTypeDOM = db.parse(inputSourceTemp);
            String nodeName = dataTypeDOM.getFirstChild().getNodeName();
            String localName = this.getDataTypeType().getName();
            if (!localName.equals(nodeName)) {
                return false;
            }
            this.parse(dataTypeDOM.getFirstChild().getTextContent());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void createDummyData() {
        if (Math.random() < 0.5) {
            this.parse("true");
        } else {
            this.parse("false");
        }
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    public String serializeToJSON() {
        String json = "'" + this.getDataTypeType().getName() + "': " + this.isValue();
        json = json.replace("'", "\"");
        return json;
    }

    public boolean deserializeFromJSON(String jsonString) {
        int pos2;
        boolean success = false;
        int pos = jsonString.indexOf("\"") + 1;
        String name = jsonString.substring(pos, pos2 = jsonString.indexOf(":") - 1);
        if (name.equals(this.getDataTypeType().getName())) {
            boolean value;
            success = true;
            Gson gson = new Gson();
            this.value = value = ((Boolean)gson.fromJson(jsonString, Boolean.class)).booleanValue();
        }
        return success;
    }

    public Boolean getValueAsObject() {
        return this.value;
    }

    public void setValueFromString(String value) {
        this.value = Boolean.parseBoolean(value);
    }

    public int compareTo(EObject o) {
        BooleanTypeInstance other = (BooleanTypeInstance)o;
        return this.getValueAsObject().compareTo(other.isValue());
    }
}

