/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.cep;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPAdministrator;
import com.espertech.esper.client.EPRuntime;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import eu.vicci.process.devices.events.SensorEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsperEngine {
    private static final Logger logger = LoggerFactory.getLogger(EsperEngine.class);
    private static final String PROVIDER_NAME = "vicciCEPEngine";
    private EPServiceProvider esp = null;
    private EPAdministrator cepAdm = null;
    private EPRuntime cep = null;
    private Configuration conf = null;

    private EsperEngine() {
        Configuration cepConfig = new Configuration();
        cepConfig.addEventType(SensorEvent.class);
        cepConfig.addEventTypeAutoName(SensorEvent.class.getPackage().getName());
        this.conf = cepConfig;
        this.esp = EPServiceProviderManager.getProvider((String)PROVIDER_NAME, (Configuration)this.conf);
        this.cep = this.esp.getEPRuntime();
        this.cepAdm = this.esp.getEPAdministrator();
    }

    public static EsperEngine getInstance() {
        return EsperEngineLoader.INSTANCE;
    }

    public EPServiceProvider getEsp() {
        return this.esp;
    }

    public EPAdministrator getCepAdm() {
        return this.cepAdm;
    }

    public EPRuntime getCep() {
        return this.cep;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void sendSensorEvent(SensorEvent event) {
        if (event == null || event.getValue() == null) {
            logger.warn("the event or its value should not be null. the event was not logged!");
            return;
        }
        this.cep.sendEvent((Object)event);
    }

    private static class EsperEngineLoader {
        static EsperEngine INSTANCE = new EsperEngine();

        private EsperEngineLoader() {
        }
    }
}

