/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.kodi.util;

import eu.vicci.process.kodi.util.KodiGuiNotification;
import eu.vicci.process.kodi.util.KodiPlayer;
import java.util.Base64;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KodiRemote {
    private static final Logger logger = LoggerFactory.getLogger(KodiRemote.class);
    private static final String auth = "kodi:kodi";
    private final String serverBaseUri;
    private final String creds;
    private Client client;

    public KodiRemote(String serverBaseUri) {
        this.serverBaseUri = serverBaseUri;
        this.client = ClientBuilder.newClient();
        byte[] out = Base64.getEncoder().encode(auth.getBytes());
        this.creds = new String(out);
    }

    public void sendNotification(String title, String message, int displayTime) {
        WebTarget target = this.client.target(this.serverBaseUri).path("jsonrpc");
        KodiGuiNotification notification = new KodiGuiNotification(title, message, displayTime);
        logger.debug("JSON-RPC: {}", (Object)notification.getAsJsonString());
        logger.debug("Send Notification to {}", (Object)target.getUri());
        logger.debug("Authorization: {}", (Object)this.creds);
        Response response = target.request().header("Authorization", (Object)("Basic " + this.creds)).post(Entity.entity((Object)notification.getAsJsonString(), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        logger.debug("JSON-RPC: {}", (Object)notification.getAsJsonString());
        logger.debug("Notification Response Status: '{}'", (Object)response.getStatus());
        logger.debug("Response: {}", response.readEntity(String.class));
    }

    public void open(String itemPath, KodiPlayer.PlayerOpenType type) {
        WebTarget target = this.client.target(this.serverBaseUri).path("jsonrpc");
        KodiPlayer.Open open = new KodiPlayer.Open(itemPath, type);
        logger.debug("JSON-RPC: {}", (Object)open.getAsJsonString());
        Response response = target.request().header("Authorization", (Object)("Basic " + this.creds)).post(Entity.entity((Object)open.getAsJsonString(), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        logger.debug("Notification Response Status: '{}'", (Object)response.getStatus());
        logger.debug("Response: {}", response.readEntity(String.class));
    }

    public void stop(int playerId) {
        WebTarget target = this.client.target(this.serverBaseUri).path("jsonrpc");
        KodiPlayer.Stop stop = new KodiPlayer.Stop(playerId);
        logger.debug("JSON-RPC: {}", (Object)stop.getAsJsonString());
        Response response = target.request().header("Authorization", (Object)("Basic " + this.creds)).post(Entity.entity((Object)stop.getAsJsonString(), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        logger.debug("Notification Response Status: '{}'", (Object)response.getStatus());
        logger.debug("Response: {}", response.readEntity(String.class));
    }
}

