/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.kodi.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class KodiPlayer {

    public static class Open {
        public static final String PLAYER_OPEN = "Player.Open";
        private String jsonString = null;
        private JsonObject jsonObject = null;

        public Open(String path, PlayerOpenType type) {
            this.process(path, type);
        }

        private void process(String path, PlayerOpenType type) {
            JsonObject notiObj = new JsonObject();
            notiObj.addProperty("jsonrpc", "2.0");
            notiObj.addProperty("method", PLAYER_OPEN);
            JsonObject itemObj = new JsonObject();
            itemObj.addProperty(type.getAsString(), path);
            JsonObject params = new JsonObject();
            params.add("item", (JsonElement)itemObj);
            notiObj.add("params", (JsonElement)params);
            notiObj.addProperty("id", (Number)1);
            this.jsonObject = notiObj;
            this.jsonString = notiObj.toString();
        }

        public String getAsJsonString() {
            return this.jsonString;
        }

        public JsonObject getAsJsonObject() {
            return this.jsonObject;
        }
    }

    public static class Stop {
        public static final String PLAYER_CLOSE = "Player.Stop";
        private String jsonString = null;
        private JsonObject jsonObject = null;

        public Stop(int playerId) {
            this.process(playerId);
        }

        private void process(int playerId) {
            JsonObject notiObj = new JsonObject();
            notiObj.addProperty("jsonrpc", "2.0");
            notiObj.addProperty("method", PLAYER_CLOSE);
            JsonObject params = new JsonObject();
            params.addProperty("playerid", (Number)playerId);
            notiObj.add("params", (JsonElement)params);
            this.jsonObject = notiObj;
            this.jsonString = notiObj.toString();
        }

        public String getAsJsonString() {
            return this.jsonString;
        }

        public JsonObject getAsJsonObject() {
            return this.jsonObject;
        }
    }

    public static enum PlayerOpenType {
        FILE("file"),
        DIRECTORY("directory");

        private final String name;

        private PlayerOpenType(String name) {
            this.name = name;
        }

        public String getAsString() {
            return this.name;
        }

        public static PlayerOpenType fromString(String string) {
            if ("file".equals(string)) {
                return FILE;
            }
            return DIRECTORY;
        }
    }
}

