/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.generator;

import eu.vicci.process.model.sofia.BooleanType;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.EndControlPort;
import eu.vicci.process.model.sofia.EndDataPort;
import eu.vicci.process.model.sofia.MapeK;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofia.SofiaFactory;
import eu.vicci.process.model.sofia.StartControlPort;
import eu.vicci.process.model.sofia.StartDataPort;
import eu.vicci.process.model.sofia.StringType;
import eu.vicci.process.model.sofia.Transition;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ProcessGenerator {
    public static Process generateProcessStub(String name, String description, String type) {
        Process p = SofiaFactory.eINSTANCE.createProcess();
        p.setName(name);
        p.setDescription(description);
        p.setType(type);
        p.setId(EcoreUtil.generateUUID());
        StartControlPort scp = SofiaFactory.eINSTANCE.createStartControlPort();
        scp.setId(EcoreUtil.generateUUID());
        scp.setName("cps1");
        EndControlPort ecp = SofiaFactory.eINSTANCE.createEndControlPort();
        ecp.setId(EcoreUtil.generateUUID());
        ecp.setName("cpe1");
        p.getPorts().add((Object)scp);
        p.getPorts().add((Object)ecp);
        return p;
    }

    public static Process generateMapeKProcess(String goal, String originalId, String wfName) {
        Process p = ProcessGenerator.generateProcessStub("mapek-for-" + originalId, "MAPE-K control process", "controlprocess");
        MapeK mp = SofiaFactory.eINSTANCE.createMapeK();
        mp.setId(EcoreUtil.generateUUID());
        p.getSubSteps().add((Object)mp);
        StartControlPort scp = SofiaFactory.eINSTANCE.createStartControlPort();
        scp.setId(EcoreUtil.generateUUID());
        scp.setName("Feedback Loop");
        EndControlPort ecp = SofiaFactory.eINSTANCE.createEndControlPort();
        ecp.setId(EcoreUtil.generateUUID());
        ecp.setName("mape-ecp");
        mp.getPorts().add((Object)scp);
        mp.getPorts().add((Object)ecp);
        Transition ts1 = SofiaFactory.eINSTANCE.createTransition();
        ts1.setId(EcoreUtil.generateUUID());
        ts1.setName("ts1");
        scp.setInTransitions(ts1);
        Transition ts2 = SofiaFactory.eINSTANCE.createTransition();
        ts2.setId(EcoreUtil.generateUUID());
        ts2.setName("ts2");
        ecp.getOutTransitions().add((Object)ts2);
        for (Port port : p.getPorts()) {
            if (port instanceof StartControlPort) {
                StartControlPort scp1 = (StartControlPort)port;
                scp1.getOutTransitions().add((Object)ts1);
                ts1.setSourcePort(port);
                continue;
            }
            if (!(port instanceof EndControlPort)) continue;
            EndControlPort ecp1 = (EndControlPort)port;
            ecp1.setInTransitions(ts2);
            ts2.setTargetPort((Port)ecp1);
        }
        StringType stgoal = SofiaFactory.eINSTANCE.createStringType();
        stgoal.setId(EcoreUtil.generateUUID());
        stgoal.setName("Goal");
        p.getDataTypeDefinitions().add((Object)stgoal);
        StartDataPort sdpgoal = SofiaFactory.eINSTANCE.createStartDataPort();
        sdpgoal.setOptional(true);
        sdpgoal.setId(EcoreUtil.generateUUID());
        sdpgoal.setName("goal");
        sdpgoal.setValue(goal);
        sdpgoal.setPortDatatype((DataType)stgoal);
        mp.getPorts().add((Object)sdpgoal);
        StringType stwfName = SofiaFactory.eINSTANCE.createStringType();
        stwfName.setId(EcoreUtil.generateUUID());
        stwfName.setName("WorkflowName");
        p.getDataTypeDefinitions().add((Object)stwfName);
        StartDataPort sdpwfName = SofiaFactory.eINSTANCE.createStartDataPort();
        sdpwfName.setOptional(true);
        sdpwfName.setId(EcoreUtil.generateUUID());
        sdpwfName.setName("start_3");
        sdpwfName.setValue(wfName);
        sdpwfName.setPortDatatype((DataType)stwfName);
        mp.getPorts().add((Object)sdpwfName);
        StringType stcuri = SofiaFactory.eINSTANCE.createStringType();
        stcuri.setId(EcoreUtil.generateUUID());
        stcuri.setName("ContextUri");
        p.getDataTypeDefinitions().add((Object)stcuri);
        StartDataPort sdpcuri = SofiaFactory.eINSTANCE.createStartDataPort();
        sdpcuri.setOptional(true);
        sdpcuri.setId(EcoreUtil.generateUUID());
        sdpcuri.setName("start_4");
        sdpcuri.setValue("http://localhost:9000/contexts/3");
        sdpcuri.setPortDatatype((DataType)stcuri);
        mp.getPorts().add((Object)sdpcuri);
        StringType stfburi = SofiaFactory.eINSTANCE.createStringType();
        stfburi.setId(EcoreUtil.generateUUID());
        stfburi.setName("FeedbackServiceUri");
        p.getDataTypeDefinitions().add((Object)stfburi);
        StartDataPort sdpfburi = SofiaFactory.eINSTANCE.createStartDataPort();
        sdpfburi.setOptional(true);
        sdpfburi.setId(EcoreUtil.generateUUID());
        sdpfburi.setName("start_2");
        sdpfburi.setValue("http://localhost:9000");
        sdpfburi.setPortDatatype((DataType)stfburi);
        mp.getPorts().add((Object)sdpfburi);
        BooleanType satis = SofiaFactory.eINSTANCE.createBooleanType();
        satis.setId(EcoreUtil.generateUUID());
        satis.setName("HasBeenSatisfied");
        p.getDataTypeDefinitions().add((Object)satis);
        EndDataPort edpsatis = SofiaFactory.eINSTANCE.createEndDataPort();
        edpsatis.setOptional(true);
        edpsatis.setId(EcoreUtil.generateUUID());
        edpsatis.setName("hasBeenSatisfied");
        edpsatis.setPortDatatype((DataType)satis);
        mp.getPorts().add((Object)edpsatis);
        BooleanType finis = SofiaFactory.eINSTANCE.createBooleanType();
        finis.setId(EcoreUtil.generateUUID());
        finis.setName("HasBeenFinished");
        p.getDataTypeDefinitions().add((Object)finis);
        EndDataPort edpfinis = SofiaFactory.eINSTANCE.createEndDataPort();
        edpfinis.setOptional(true);
        edpfinis.setId(EcoreUtil.generateUUID());
        edpfinis.setName("hasBeenFinished");
        edpfinis.setPortDatatype((DataType)finis);
        mp.getPorts().add((Object)edpfinis);
        return p;
    }
}

