/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.devices.util;

import eu.vicci.openhab.util.IOpenHabRestClient;
import eu.vicci.openhab.util.OpenHabRestClient;
import eu.vicci.process.devices.DeviceManager;
import eu.vicci.process.devices.core.Sensor;
import eu.vicci.process.devices.events.SensorEvent;
import eu.vicci.process.devices.util.Devicifier;
import eu.vicci.process.devices.util.OpenHabEvent;
import eu.vicci.process.model.cep.EsperEngine;
import eu.vicci.process.model.util.configuration.ConfigurationManager;
import eu.vicci.process.openhab.util.OpenHabEventProvider;
import java.util.List;

public class OpenHabListener {
    private static final String DEFAULT_SERVER_URI = "http://localhost:8080";
    private String openHabBaseUri = null;
    private boolean isRunning = false;
    private OpenHabEventProvider provider = null;
    private IOpenHabRestClient restClient = null;
    private static final String OH_DecimalType = "DecimalType";

    private OpenHabListener() {
    }

    public static OpenHabListener getInstance() {
        return OpenHabListenerHolder.INSTANCE;
    }

    public void start() {
        String uri = ConfigurationManager.getInstance().getConfigAsString("OPENHAB_URI");
        if (uri == null) {
            this.start(DEFAULT_SERVER_URI);
        } else {
            this.start(uri);
        }
    }

    public synchronized void start(String openHabBaseUri) {
        if (this.isRunning) {
            throw new IllegalStateException("Listener already running!");
        }
        this.openHabBaseUri = openHabBaseUri;
        this.startRestClientAndRegisterAllDevices();
        this.startEventProvider();
        this.isRunning = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void close() {
        if (!this.isRunning) {
            throw new IllegalStateException("Listener is not running!");
        }
        this.provider.closeAllEventSources();
        this.isRunning = false;
        this.provider = null;
        this.restClient = null;
        this.openHabBaseUri = null;
    }

    private void startRestClientAndRegisterAllDevices() {
        this.restClient = new OpenHabRestClient(this.openHabBaseUri);
        this.getAllSensorsSemantic();
    }

    private void getAllSensorsSemantic() {
        List sensors = this.restClient.getAllSensorsSemantic();
        DeviceManager.getInstance().addDevices(sensors);
    }

    private void startEventProvider() {
        this.provider = new OpenHabEventProvider(this.openHabBaseUri);
        this.provider.registerToItemState(new OpenHabEventProvider.OHEventItemStateListener(){

            @Override
            public void onItemState(OpenHabEvent.OHItemStateEvent event) {
                OpenHabListener.this.addSensorEventToEsper(event);
            }
        });
        this.provider.registerToItemAdded(new OpenHabEventProvider.OHEventItemAddedListener(){

            @Override
            public void onItemAdded(OpenHabEvent.OHItemAddedEvent event) {
                OpenHabListener.this.getAllSensorsSemantic();
            }
        });
        this.provider.registerToItemRemoved(new OpenHabEventProvider.OHEventItemRemovedListener(){

            @Override
            public void onItemRemoved(OpenHabEvent.OHItemRemovedEvent event) {
                DeviceManager.getInstance().removeDevice(event.getItemName());
            }
        });
    }

    private void addSensorEventToEsper(OpenHabEvent.OHItemStateEvent openHabEvent) {
        Sensor sensor = Devicifier.createDevice(openHabEvent, this.restClient);
        OpenHabEvent.OHItemStatePayload payload = (OpenHabEvent.OHItemStatePayload)openHabEvent.getTypedPayload();
        Object value = this.castValueToType(payload);
        SensorEvent event = new SensorEvent(sensor.getEventType(), value, openHabEvent.getTimeStamp(), sensor);
        EsperEngine.getInstance().sendSensorEvent(event);
    }

    private Object castValueToType(OpenHabEvent.OHItemStatePayload payload) {
        if (OH_DecimalType.equals(payload.getType())) {
            return this.tryCastNumber(payload.getValue());
        }
        return payload.getValue();
    }

    private Object tryCastNumber(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (Exception exception2) {
                try {
                    return Double.parseDouble(value);
                }
                catch (Exception exception3) {
                    try {
                        return Long.parseLong(value);
                    }
                    catch (Exception exception4) {
                        return value;
                    }
                }
            }
        }
    }

    private static class OpenHabListenerHolder {
        private static final OpenHabListener INSTANCE = new OpenHabListener();

        private OpenHabListenerHolder() {
        }
    }
}

