/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.devices.util;

import com.google.gson.Gson;

public class OpenHabEvent {
    private String topic;
    protected String payload;
    private String type;
    private String itemName = null;
    private long timeStamp = System.currentTimeMillis();

    public String getTopic() {
        return this.topic;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getItemName() {
        if (this.itemName != null) {
            return this.itemName;
        }
        this.setItemNameFromTopic();
        return this.itemName;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getType() {
        return this.type;
    }

    private void setItemNameFromTopic() {
        int last = this.topic.lastIndexOf("/");
        String temp = this.topic.substring(0, last);
        last = temp.lastIndexOf("/");
        this.itemName = temp.substring(last + 1);
    }

    public static OpenHabEvent fromJson(String json) {
        Gson gson = new Gson();
        OpenHabEvent tmp = (OpenHabEvent)gson.fromJson(json, OpenHabEvent.class);
        if ("ItemAddedEvent".equals(tmp.type)) {
            return (OpenHabEvent)gson.fromJson(json, OHItemAddedEvent.class);
        }
        if ("ItemRemovedEvent".equals(tmp.type)) {
            return (OpenHabEvent)gson.fromJson(json, OHItemRemovedEvent.class);
        }
        if ("ItemUpdatedEvent".equals(tmp.type)) {
            return (OpenHabEvent)gson.fromJson(json, OHItemUpdatedEvent.class);
        }
        if ("ItemStateChangedEvent".equals(tmp.type)) {
            return (OpenHabEvent)gson.fromJson(json, OHItemStateChangedEvent.class);
        }
        if ("ItemStateEvent".equals(tmp.type)) {
            return (OpenHabEvent)gson.fromJson(json, OHItemStateEvent.class);
        }
        if ("ItemCommandEvent".equals(tmp.type)) {
            return (OpenHabEvent)gson.fromJson(json, OHItemCommandEvent.class);
        }
        return tmp;
    }

    public static <T extends OpenHabEvent> T fromJson(String json, Class<T> clazz) {
        OpenHabEvent tmp = OpenHabEvent.fromJson(json);
        if (tmp.getClass().equals(clazz)) {
            return (T)tmp;
        }
        return null;
    }

    public static class OHItemRemovedPayload
    extends OHItemAddedPayload {
    }

    public static class OHItemCommandPayload
    extends OHItemStatePayload {
    }

    public static class OHItemStatePayload {
        private String type;
        private String value;

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class OHItemStateChangedPayload
    extends OHItemStatePayload {
        private String oldType;
        private String oldValue;

        public String getOldType() {
            return this.oldType;
        }

        public String getOldValue() {
            return this.oldValue;
        }
    }

    public static class OHItemAddedPayload {
        private String type;
        private String name;
        private String label;
        private String[] tags;
        private String[] groupNames;

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public String[] getTags() {
            return this.tags;
        }

        public String[] getGroupNames() {
            return this.groupNames;
        }
    }

    public static class OHItemCommandEvent
    extends OpenHabTypedEvent<OHItemCommandPayload> {
        public static final String TYPE_ID = "ItemCommandEvent";

        @Override
        protected OHItemCommandPayload createPayload() {
            return (OHItemCommandPayload)new Gson().fromJson(this.payload, OHItemCommandPayload.class);
        }
    }

    public static class OHItemStateEvent
    extends OpenHabTypedEvent<OHItemStatePayload> {
        public static final String TYPE_ID = "ItemStateEvent";

        @Override
        protected OHItemStatePayload createPayload() {
            return (OHItemStatePayload)new Gson().fromJson(this.payload, OHItemStatePayload.class);
        }
    }

    public static class OHItemStateChangedEvent
    extends OpenHabTypedEvent<OHItemStateChangedPayload> {
        public static final String TYPE_ID = "ItemStateChangedEvent";

        @Override
        protected OHItemStateChangedPayload createPayload() {
            return (OHItemStateChangedPayload)new Gson().fromJson(this.payload, OHItemStateChangedPayload.class);
        }
    }

    public static class OHItemUpdatedEvent
    extends OpenHabTypedEvent<String> {
        public static final String TYPE_ID = "ItemUpdatedEvent";

        @Override
        protected String createPayload() {
            return this.payload;
        }
    }

    public static class OHItemRemovedEvent
    extends OpenHabTypedEvent<OHItemRemovedPayload> {
        public static final String TYPE_ID = "ItemRemovedEvent";

        @Override
        protected OHItemRemovedPayload createPayload() {
            return (OHItemRemovedPayload)new Gson().fromJson(this.payload, OHItemRemovedPayload.class);
        }
    }

    public static class OHItemAddedEvent
    extends OpenHabTypedEvent<OHItemAddedPayload> {
        public static final String TYPE_ID = "ItemAddedEvent";

        @Override
        protected OHItemAddedPayload createPayload() {
            return (OHItemAddedPayload)new Gson().fromJson(this.payload, OHItemAddedPayload.class);
        }
    }

    public static abstract class OpenHabTypedEvent<T>
    extends OpenHabEvent {
        protected transient T typedPayload;

        public T getTypedPayload() {
            if (this.typedPayload == null) {
                this.typedPayload = this.createPayload();
            }
            return this.typedPayload;
        }

        protected abstract T createPayload();
    }
}

