/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.devices.util;

import eu.vicci.process.devices.core.Sensor;
import eu.vicci.process.devices.events.EventManager;
import eu.vicci.process.devices.events.SensorEvent;
import eu.vicci.process.devices.events.core.EventType;
import eu.vicci.process.model.cep.EsperManager;
import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.DoubleTypeInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import java.util.LinkedHashMap;

public class Eventifier {
    private SensorEvent event;
    private EventType et;
    private Sensor thisSens;

    public Eventifier(DataPortInstance dpi, Sensor sensor) {
        SensorEvent event;
        Object latestValue = null;
        DataTypeInstance dti = dpi.getDataInstance();
        if (dti instanceof StringTypeInstance) {
            StringTypeInstance sti = (StringTypeInstance)dti;
            latestValue = sti.getValue();
        } else if (dti instanceof IntegerTypeInstance) {
            IntegerTypeInstance iti = (IntegerTypeInstance)dti;
            latestValue = iti.getValue();
        } else if (dti instanceof DoubleTypeInstance) {
            DoubleTypeInstance doti = (DoubleTypeInstance)dti;
            latestValue = doti.getValue();
        } else if (dti instanceof BooleanTypeInstance) {
            BooleanTypeInstance bti = (BooleanTypeInstance)dti;
            latestValue = bti.isValue();
        }
        this.event = event = this.createEvent(sensor.getSensing(), latestValue, sensor, System.currentTimeMillis());
        this.addEventTypeToEsper(event, sensor);
    }

    public SensorEvent getEvent() {
        return this.event;
    }

    private SensorEvent createEvent(String sensing, Object latestValue, Sensor sensor, long timestamp) {
        if (sensor.getEventType() == null) {
            return null;
        }
        SensorEvent event = new SensorEvent(sensor.getEventType(), latestValue, timestamp, sensor);
        this.addEventTypeToEsper(event, sensor);
        EventManager.getInstance().getEventList().add(event);
        return event;
    }

    private void addEventTypeToEsper(SensorEvent se, Sensor sen) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        String sensing = sen.getSensing();
        Class<?> datatype = null;
        if (se.getValue() != null) {
            datatype = se.getValue().getClass();
            sen.setDatatype(datatype);
        }
        if (sensing == null) {
            return;
        }
        sen.setEventType(this.et);
        props.put("id", String.class);
        props.put("location", String.class);
        props.put("type", String.class);
        props.put("sensing", String.class);
        props.put("value", datatype.getClass());
        EsperManager.getInstance().addEventType(this.et.getTypeName(), props);
    }
}

