/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.devices.util;

import eu.vicci.openhab.util.IOpenHabRestClient;
import eu.vicci.process.devices.DeviceManager;
import eu.vicci.process.devices.core.Device;
import eu.vicci.process.devices.core.Sensor;
import eu.vicci.process.devices.events.EventManager;
import eu.vicci.process.devices.events.core.EventType;
import eu.vicci.process.devices.util.OpenHabEvent;
import eu.vicci.process.model.cep.EsperManager;
import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.DoubleTypeInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import java.util.LinkedHashMap;

public class Devicifier {
    private Devicifier() {
    }

    public static Sensor createDevice(OpenHabEvent openHabEvent, IOpenHabRestClient restClient) {
        Sensor device = DeviceManager.getInstance().getDeviceIfRegistered(openHabEvent.getItemName(), Sensor.class);
        if (device != null) {
            return device;
        }
        EventType eventType = EventManager.getInstance().addEventTypeIfNotExists("unknow", String.class);
        device = new Sensor(openHabEvent.getItemName(), "unknow", "unknow", eventType, String.class, "");
        DeviceManager.getInstance().addDevice((Device)device);
        return device;
    }

    public static Sensor createDevice(DataPortInstance dpi) {
        String sensing;
        String uid = dpi.getInstanceId();
        String location = "";
        String type = sensing = dpi.getPortType().getName();
        DataTypeInstance dti = dpi.getDataInstance();
        Class cls = null;
        if (dti instanceof StringTypeInstance) {
            cls = String.class;
        } else if (dti instanceof IntegerTypeInstance) {
            cls = Integer.class;
        } else if (dti instanceof DoubleTypeInstance) {
            cls = Double.class;
        } else if (dti instanceof BooleanTypeInstance) {
            cls = Boolean.class;
        }
        Sensor sensor = DeviceManager.getInstance().getDeviceIfRegistered(uid, Sensor.class);
        if (sensor != null) {
            return sensor;
        }
        EventType et = EventManager.getInstance().addEventTypeIfNotExists(sensing, cls);
        sensor = new Sensor(uid, location, sensing, type, et, cls);
        DeviceManager.getInstance().addDevice((Device)sensor);
        Devicifier.addEventTypeToEsper(et, cls);
        return sensor;
    }

    private static void addEventTypeToEsper(EventType eventType, Class<?> datatype) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("id", String.class);
        props.put("location", String.class);
        props.put("type", String.class);
        props.put("sensing", String.class);
        props.put("value", datatype);
        EsperManager.getInstance().addEventType(eventType.getTypeName(), props);
    }
}

