/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.devices.events;

import eu.vicci.process.devices.core.Device;
import eu.vicci.process.devices.events.Event;
import eu.vicci.process.devices.events.core.EventType;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class EventManager {
    private List<Event<? extends Device>> eventList = new LinkedList<Event<? extends Device>>();
    private List<EventType> eventTypes = new LinkedList<EventType>();

    private EventManager() {
    }

    public static EventManager getInstance() {
        return EventManagerLoader.INSTANCE;
    }

    public List<Event<? extends Device>> getEventList() {
        return this.eventList;
    }

    public void addEvent(Event<? extends Device> e) {
        this.eventList.add(e);
    }

    public void removeEvent(Event<? extends Device> e) {
        this.eventList.remove(e);
    }

    public List<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public boolean containsEventType(String type) {
        return this.eventTypes.stream().anyMatch(ev -> ev.getTypeName().equals(type));
    }

    public EventType addEventTypeIfNotExists(String type, Class<?> clazz) {
        Optional<EventType> eventType = this.eventTypes.stream().filter(ev -> ev.getTypeName().equals(type)).findFirst();
        if (eventType.isPresent()) {
            return eventType.get();
        }
        EventType newEventType = new EventType(type, clazz);
        this.eventTypes.add(newEventType);
        return newEventType;
    }

    private static class EventManagerLoader {
        static EventManager INSTANCE = new EventManager();

        private EventManagerLoader() {
        }
    }
}

