/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.devices;

import eu.vicci.process.devices.core.Device;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceManager {
    private static DeviceManager dm;
    private Map<String, Device> devices = Collections.synchronizedMap(new HashMap());

    private DeviceManager() {
    }

    public static synchronized DeviceManager getInstance() {
        if (dm == null) {
            dm = new DeviceManager();
        }
        return dm;
    }

    public Map<String, Device> getDevices() {
        return this.devices;
    }

    public void addDevice(Device device) {
        this.devices.put(device.getUid(), device);
    }

    public void addDevices(List<? extends Device> devices) {
        for (Device device : devices) {
            this.devices.put(device.getUid(), device);
        }
    }

    public void updateDevice(Device device) {
        this.devices.put(device.getUid(), device);
    }

    public Device removeDevice(Device device) {
        return this.devices.remove(device.getUid());
    }

    public Device removeDevice(String uid) {
        return this.devices.remove(uid);
    }

    public <T extends Device> T getDeviceIfRegistered(String uid, Class<T> clazz) {
        Device device = this.devices.get(uid);
        if (device == null || !device.getClass().equals(clazz)) {
            return null;
        }
        return (T)device;
    }
}

