/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.actors;

import akka.dispatch.Futures;
import akka.pattern.Patterns;
import eu.vicci.process.actors.ActorBase;
import eu.vicci.process.messages.CreateChildActorMessage;
import eu.vicci.process.messages.DeactivateTransitionMessage;
import eu.vicci.process.messages.ExecuteTransitionMessage;
import eu.vicci.process.model.sofiainstance.TransitionInstance;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public final class TransitionActor
extends ActorBase {
    private final TransitionInstance transitionInstance;

    public TransitionActor(TransitionInstance transitionInstance) {
        this.transitionInstance = transitionInstance;
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof ExecuteTransitionMessage) {
            this.execute((ExecuteTransitionMessage)message);
        } else if (message instanceof CreateChildActorMessage) {
            this.createChild((CreateChildActorMessage)message);
        } else if (message instanceof DeactivateTransitionMessage) {
            this.transitionInstance.deactivate();
        } else {
            this.unhandled(message);
        }
    }

    private void execute(ExecuteTransitionMessage message) {
        if (message.isBlockingCall()) {
            this.executeSync(message);
        } else {
            this.transitionInstance.execute(message.getParameter());
        }
    }

    private void executeSync(ExecuteTransitionMessage message) {
        this.transitionInstance.execute(message.getParameter());
        Future future = Futures.successful((Object)true);
        Patterns.pipe((Future)future, (ExecutionContext)this.context().dispatcher()).to(this.getSender(), this.getSelf());
    }
}

