/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.actors;

import eu.vicci.process.actors.ActorBase;
import eu.vicci.process.messages.CreateChildActorMessage;
import eu.vicci.process.messages.DeactivateProcessStepMessage;
import eu.vicci.process.messages.EscalateProcessStepMessage;
import eu.vicci.process.messages.ExecuteProcessStepMessage;
import eu.vicci.process.messages.KillProcessStepMessage;
import eu.vicci.process.messages.PauseProcessStepMessage;
import eu.vicci.process.messages.PortExecutionStateChangedMessage;
import eu.vicci.process.messages.ProcessExecutedMessage;
import eu.vicci.process.messages.ProcessResetMessage;
import eu.vicci.process.messages.ResetProcessMessage;
import eu.vicci.process.messages.ResumeProcessStepMessage;
import eu.vicci.process.messages.StopProcessStepMessage;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;

public final class ProcessStepActor
extends ActorBase {
    private final ProcessStepInstanceImplCustom processStepInstance;

    public ProcessStepActor(ProcessStepInstanceImplCustom processStepInstance) {
        this.processStepInstance = processStepInstance;
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof ExecuteProcessStepMessage) {
            this.processStepInstance.execute();
        } else if (message instanceof CreateChildActorMessage) {
            this.createChild((CreateChildActorMessage)message);
        } else if (message instanceof ProcessExecutedMessage) {
            this.processStepInstance.processExecuted(((ProcessExecutedMessage)message).getProcessStepInstance());
        } else if (message instanceof DeactivateProcessStepMessage) {
            this.processStepInstance.deactivate();
        } else if (message instanceof StopProcessStepMessage) {
            this.processStepInstance.stop();
        } else if (message instanceof KillProcessStepMessage) {
            this.processStepInstance.kill();
        } else if (message instanceof PauseProcessStepMessage) {
            this.processStepInstance.pause();
        } else if (message instanceof ResumeProcessStepMessage) {
            this.processStepInstance.resume();
        } else if (message instanceof ResetProcessMessage) {
            this.processStepInstance.reset();
        } else if (message instanceof ProcessResetMessage) {
            this.processStepInstance.processReset(((ProcessResetMessage)message).getResetProcess());
        } else if (message instanceof PortExecutionStateChangedMessage) {
            this.processStepInstance.portExecutionStateChanged(((PortExecutionStateChangedMessage)message).getPort());
        } else if (message instanceof EscalateProcessStepMessage) {
            this.processStepInstance.escalate();
        } else {
            this.unhandled(message);
        }
    }
}

