/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.actors;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.TypedActor;
import akka.actor.TypedProps;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.pattern.Patterns;
import akka.util.Timeout;
import eu.vicci.process.actors.IProcessExecutionMasterActor;
import eu.vicci.process.messages.CreateChildActorMessage;
import java.util.concurrent.TimeUnit;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public final class ProcessExecutionMasterActor
implements IProcessExecutionMasterActor {
    private static final int DEFAULT_TIMEOUT = 5;
    LoggingAdapter logging = Logging.getLogger((ActorSystem)TypedActor.context().system(), (Object)this);

    @Override
    public void sendSimpleMessage(ActorRef receiver, Object message) {
        receiver.tell(message, TypedActor.context().self());
    }

    @Override
    public ActorRef createChildActor(ActorRef parent, CreateChildActorMessage message) {
        if (parent == null) {
            return ProcessExecutionMasterActor.getActorRefWithoutParent(message);
        }
        Timeout timeout = new Timeout(Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
        Future result = Patterns.ask((ActorRef)parent, (Object)message, (Timeout)timeout);
        try {
            return (ActorRef)Await.result((Awaitable)result, (Duration)timeout.duration());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ProcessExecutionMasterActor.getActorRefWithoutParent(message);
        }
    }

    @Override
    public Future<Object> sendMessageAndReceiveFuture(ActorRef receiver, Object message, Timeout timeout) {
        Future result = Patterns.ask((ActorRef)receiver, (Object)message, (Timeout)timeout);
        return result;
    }

    public static IProcessExecutionMasterActor create(ActorSystem system, String name) {
        IProcessExecutionMasterActor actor = (IProcessExecutionMasterActor)TypedActor.get((ActorSystem)system).typedActorOf(new TypedProps(IProcessExecutionMasterActor.class, ProcessExecutionMasterActor.class), name);
        return actor;
    }

    private static ActorRef getActorRefWithoutParent(CreateChildActorMessage message) {
        Props props = Props.create(message.getChildActorFactory());
        if (message.getActorName() == null) {
            return TypedActor.context().actorOf(props);
        }
        return TypedActor.context().actorOf(props, message.getActorName());
    }
}

