package eu.vicci.process.openhab.util;

/**
 * 
 * Documentation about EventTopics
 * <a href="https://eclipse.org/smarthome/documentation/concepts/events.html">Events</a>
 * 
 */
public class OpenHabEventTopics {	

	/**
	 * an item state update event was sent
	 */
	public static final String ITEM_STATE = "smarthome/items/*/state";
	
	/**
	 * The state of an item has changed.
	 */
	public static final String ITEM_STATE_CHANGED = "smarthome/items/*/statechanged";
	
	/**
	 * An item has been added to the item registry.
	 */
	public static final String ITEM_ADDED = "smarthome/items/*/added";
	
	/**
	 * An item has been removed from the item registry.
	 */
	public static final String ITEM_REMOVED = "smarthome/items/*/removed";
	
	/**
	 * An item has been updated in the item registry.
	 */
	public static final String ITEM_UPDATED = "smarthome/items/*/updated";
	
	/**
	 * A command is sent to an item via a channel.
	 */
	public static final String ITEM_COMMAND = "smarthome/items/*/command";
	
}
