/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.engine.internal;

import eu.vicci.process.engine.core.IProcessManager;
import eu.vicci.process.engine.internal.IProcessManagerInternal;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.sofiainstance.impl.custom.SofiaInstanceFactoryImplCustom;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONProcessStepInstanceSerializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class ProcessInstancePersistor {
    private final IProcessManagerInternal processManager;
    private final IProcessManager publicManager;

    public ProcessInstancePersistor(IProcessManagerInternal processManager, IProcessManager publicManager) {
        this.processManager = processManager;
        this.publicManager = publicManager;
    }

    public synchronized String persistInstance(ProcessInstance pi) {
        String path = "./processes/instances/" + pi.getInstanceId() + ".sofiainstance";
        Path filepath = FileSystems.getDefault().getPath(path, new String[0]);
        String serialized = JSONProcessStepInstanceSerializer.serialize((ProcessStepInstance)pi);
        try {
            Files.write(filepath, serialized.getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.processManager.getPersistedinstances().put(pi.getInstanceId(), path);
        return path;
    }

    public synchronized ProcessInstance readPersistedInstance(String instanceId) {
        String path = this.processManager.getPersistedinstances().get(instanceId);
        File file = new File(path);
        String stream = "";
        try {
            FileReader fr = new FileReader(file);
            BufferedReader reader = new BufferedReader(fr);
            stream = reader.readLine();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ProcessInstance pi = (ProcessInstance)JSONProcessStepInstanceSerializer.deserialize((String)stream, (SofiaInstanceFactory)SofiaInstanceFactoryImplCustom.getInstance());
        Process p = this.publicManager.getProcessInfos(pi.getProcessModelID());
        pi.setProcessStepType((ProcessStep)p);
        return pi;
    }
}

