/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.engine;

import eu.vicci.process.client.core.AbstractClientBuilder;
import eu.vicci.process.engine.ProcessModelLoader;
import eu.vicci.process.engine.core.ClientBuilderFactory;
import eu.vicci.process.engine.core.IProcessInfo;
import eu.vicci.process.engine.core.IProcessInstanceInfo;
import eu.vicci.process.engine.core.IProcessManager;
import eu.vicci.process.engine.internal.IProcessManagerInternal;
import eu.vicci.process.engine.internal.ProcessInstanceExecutor;
import eu.vicci.process.engine.internal.ProcessInstancePersistor;
import eu.vicci.process.engine.internal.ProcessManagerInternal;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofiainstance.Configuration;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.impl.custom.ConfigurationImplCustom;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import eu.vicci.process.model.util.ProcessInfo;
import eu.vicci.process.model.util.ProcessInstanceInfo;
import eu.vicci.process.model.util.logging.InstanceLogger;
import eu.vicci.process.model.util.logging.LoggingManager;
import eu.vicci.process.model.util.messages.MessageQueue;
import eu.vicci.process.model.util.messages.core.HumanTaskRequestListener;
import eu.vicci.process.model.util.messages.core.HumanTaskResponseListener;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.ProcessEngineListener;
import eu.vicci.process.model.util.messages.core.StateChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.util.XMLProcessor;

public class ProcessManagerPublic
implements IProcessManager {
    private static final String PATH_MODEL = "./processes/models/";
    private static final String PATH_DIAGRAM = "./processes/diagrams/";
    private ProcessInstanceExecutor processInstanceExecutor;
    private ProcessInstancePersistor processInstancePersistor;
    private IProcessManagerInternal processManager;
    private final MessageQueue messageQueue;
    private ClientBuilderFactory clientBuilderFactory;
    private List<ProcessEngineListener> engineListeners = new ArrayList<ProcessEngineListener>();

    public ProcessManagerPublic() {
        this.processManager = new ProcessManagerInternal();
        this.messageQueue = new MessageQueue();
        this.messageQueue.schedule();
        this.processInstanceExecutor = new ProcessInstanceExecutor(this.processManager, this.messageQueue, this);
        this.processInstancePersistor = new ProcessInstancePersistor(this.processManager, this);
        this.processManager.setProcessInstancePersistor(this.processInstancePersistor);
    }

    public String uploadProcessDefinition(String processid, String processdocument, boolean isDiagram) {
        return this.uploadProcessDefinition(processid, processdocument, isDiagram, false);
    }

    public String uploadProcessDefinition(String processid, String processdocument, boolean isDiagram, boolean overrideExisting) {
        try {
            this.printUploadedDoc(processdocument);
            String path = "";
            path = isDiagram ? URI.createURI((String)(PATH_DIAGRAM + processid + ".diagram")).toFileString() : URI.createURI((String)(PATH_MODEL + processid + ".sofia")).toFileString();
            File file = new File(path);
            file.getParentFile().mkdirs();
            if (file.exists() && overrideExisting) {
                file.delete();
            }
            if (file.exists()) {
                this.processManager.getUploadedProcesses().put(processid, path);
                return processid;
            }
            file.createNewFile();
            FileWriter fw = new FileWriter(file, true);
            fw.write(processdocument);
            fw.close();
            this.printPath(path.toString());
            this.processManager.getUploadedProcesses().put(processid, path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return processid;
    }

    public Map<String, String> getUploadedProcesses() {
        return this.processManager.getUploadedProcesses();
    }

    public String deployProcess(Process process) {
        System.out.println("ProcessManager.deployProcess()");
        this.processManager.getDeployedprocesses().put(process.getId(), process);
        ProcessInfo info = new ProcessInfo(process);
        this.engineListeners.stream().forEach(arg_0 -> ProcessManagerPublic.lambda$deployProcess$0((IProcessInfo)info, arg_0));
        return process.getId();
    }

    public String deployProcess(String processid) {
        ProcessModelLoader pml = new ProcessModelLoader();
        Process p = pml.loadUri(this.processManager.getUploadedProcesses().get(processid));
        return this.deployProcess(p);
    }

    public String deployProcessInstance(String processid) {
        System.out.println("ProcessManager.deployProcessInstance()");
        ProcessInstance instance = this.processInstanceExecutor.deploy(processid);
        ProcessInstanceInfo info = new ProcessInstanceInfo(instance);
        this.engineListeners.stream().forEach(arg_0 -> ProcessManagerPublic.lambda$deployProcessInstance$1((IProcessInstanceInfo)info, arg_0));
        return instance.getInstanceId();
    }

    public String configureProcessInstance(String processid, String configuration) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(configuration.getBytes());
            Configuration recoveredConfig = null;
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ConfigurationImplCustom.class});
            Unmarshaller um = context.createUnmarshaller();
            recoveredConfig = (Configuration)um.unmarshal((InputStream)stream);
            this.processInstanceExecutor.configure(processid, recoveredConfig);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return "success";
    }

    public String startProcessInstance(String processInstanceId, Map<String, DataTypeInstance> inputParameters) {
        return this.startProcessInstance(processInstanceId, inputParameters, false);
    }

    public String startProcessInstance(String processInstanceId, Map<String, DataTypeInstance> inputParameters, boolean runInLoop) {
        return this.startProcessInstance(processInstanceId, null, inputParameters, runInLoop);
    }

    public String startProcessInstance(String processInstanceId, String runningForInstanceId, Map<String, DataTypeInstance> inputParameters, boolean runInLoop) {
        System.out.println("ProcessManager.startProcessInstance()");
        this.processInstanceExecutor.execute(processInstanceId, runningForInstanceId, inputParameters);
        return "success";
    }

    public String stopProcessInstance(String instanceid) {
        LifeCycleManager.INSTANCE.reset();
        return "success";
    }

    public String pauseProcessInstance(String instanceid) {
        ProcessInstance pi = this.processManager.getProcessInstance(instanceid);
        pi.pause();
        return "success";
    }

    public String getProcessDefinition(String processid) {
        String path = this.processManager.getUploadedProcesses().get(processid);
        String text = "";
        File file = new File(path);
        try {
            Scanner scanner = new Scanner(file);
            scanner.useDelimiter("\\z");
            text = scanner.next();
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return text;
    }

    public List<String> listUploadedProcessDefinitions() {
        LinkedList<String> processids = new LinkedList<String>();
        for (String id : this.processManager.getUploadedProcesses().keySet()) {
            processids.add(id);
        }
        return processids;
    }

    public List<IProcessInfo> listDeployedProcesses() {
        ArrayList<IProcessInfo> processInfos = new ArrayList<IProcessInfo>();
        for (Process p : this.processManager.getDeployedprocesses().values()) {
            ProcessInfo info = new ProcessInfo(p);
            processInfos.add((IProcessInfo)info);
        }
        return processInfos;
    }

    public List<IProcessInstanceInfo> listProcessInstances() {
        ArrayList<IProcessInstanceInfo> instanceInfos = new ArrayList<IProcessInstanceInfo>();
        for (ProcessInstance procIns : this.processManager.getProcessinstances().keySet()) {
            ProcessInstanceInfo pii = new ProcessInstanceInfo(procIns);
            instanceInfos.add((IProcessInstanceInfo)pii);
        }
        return instanceInfos;
    }

    public String resumeProcessInstance(String processInstanceId) {
        ProcessInstance pi = this.processManager.getProcessInstance(processInstanceId);
        pi.resume();
        return "success";
    }

    public Process getProcessInfos(String processId) {
        Process proc = this.processManager.getProcess(processId);
        return proc;
    }

    public ProcessInstance getProcessInstanceInfos(String processInstanceId) {
        ProcessInstance procIns = this.processManager.getProcessInstance(processInstanceId);
        return procIns;
    }

    public String uploadModelFile(String filepath) {
        return this.uploadModelFile(filepath, false);
    }

    public String uploadModelFile(String filepath, boolean overrideExisting) {
        Process model = null;
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(URI.createURI((String)filepath), true);
        model = filepath.endsWith(".diagram") ? (Process)resource.getContents().get(1) : (Process)resource.getContents().get(0);
        String processId = model.getId();
        XMLResourceImpl resource2 = new XMLResourceImpl();
        XMLProcessor processor = new XMLProcessor();
        resource2.getContents().add((Object)model);
        try {
            String text = processor.saveToString((Resource)resource2, null);
            this.printModel(text);
            return this.uploadProcessDefinition(processId, text, false, overrideExisting);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadExistingModels() {
        File modelFolder = new File(PATH_MODEL);
        for (File modelFile : modelFolder.listFiles()) {
            String path = "";
            try {
                path = modelFile.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Process deployedprocess = null;
            ResourceSetImpl resSet = new ResourceSetImpl();
            Resource resource = resSet.getResource(URI.createURI((String)path), true);
            deployedprocess = (Process)resource.getContents().get(0);
            this.processManager.getUploadedProcesses().put(deployedprocess.getId(), path);
            this.deployProcess(deployedprocess.getId());
        }
        File diagramFolder = new File(PATH_DIAGRAM);
        for (File diagramFile : diagramFolder.listFiles()) {
            String path = "";
            try {
                path = diagramFile.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            path = path.replace("\\", "/");
            int temp = path.lastIndexOf(47);
            int temp2 = path.indexOf(".diagram");
            String filename = path.substring(temp, temp2);
            String path2 = PATH_MODEL + filename + ".sofia";
            File model = new File(path2);
            if (!model.exists()) {
                Process deployedprocess = null;
                ResourceSetImpl resSet = new ResourceSetImpl();
                Resource resource = resSet.getResource(URI.createURI((String)path), true);
                deployedprocess = (Process)resource.getContents().get(1);
                this.deployProcess(deployedprocess.getId());
                ResourceSetImpl resSet2 = new ResourceSetImpl();
                Resource resource2 = resSet2.createResource(URI.createURI((String)path2));
                resource2.getContents().add((Object)deployedprocess);
                try {
                    resource2.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.processManager.getUploadedProcesses().put(deployedprocess.getId(), path2);
                continue;
            }
            System.out.println("Model already existing");
        }
    }

    public Map<String, String> getProcessInstanceInfosReduced(String processInstanceId) {
        ProcessInstance procIns = this.getProcessInstanceInfos(processInstanceId);
        HashMap<String, String> processStepsList = new HashMap<String, String>();
        processStepsList.put(procIns.getProcessStepType().getId(), procIns.getInstanceId());
        if (procIns.getSubSteps().size() > 0) {
            this.traverseSteps((ProcessStepInstance)procIns, processStepsList);
        }
        return processStepsList;
    }

    public String removeInstance(String processInstanceId) {
        for (ProcessInstance pi : this.processManager.getProcessinstances().keySet()) {
            if (!pi.getInstanceId().equals(processInstanceId)) continue;
            this.processManager.getProcessinstances().keySet().remove(pi);
            LifeCycleManager.INSTANCE.reset();
            return "success";
        }
        return "error";
    }

    public IStateChangeMessage getInstanceState(String processInstanceId) {
        InstanceLogger il = (InstanceLogger)LoggingManager.getInstance().getLoggers().get(processInstanceId);
        return il.getRecentLoggingMessage();
    }

    public List<IStateChangeMessage> getInstanceLog(String processInstanceId) {
        InstanceLogger il = (InstanceLogger)LoggingManager.getInstance().getLoggers().get(processInstanceId);
        return il.getLoggingMessages();
    }

    private void traverseSteps(ProcessStepInstance psi, Map<String, String> stepList) {
        for (ProcessStepInstance psubi : psi.getSubSteps()) {
            stepList.put(psubi.getProcessStepType().getId(), psubi.getInstanceId());
            if (psubi.getSubSteps().size() <= 0) continue;
            this.traverseSteps(psubi, stepList);
        }
    }

    public List<IStateChangeMessage> getRecentStateChanges() {
        return LoggingManager.getInstance().getRecentStateChanges();
    }

    public ProcessStepInstance executeProcessStep(ProcessStepInstance psi, ProcessStep ps, boolean alreadyExecuting) {
        psi.setProcessStepType(ps);
        if (!alreadyExecuting) {
            psi.execute();
            while (!psi.getExecutionState().equals((Object)State.EXECUTED)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return psi;
        }
        return null;
    }

    public String uploadAndDeploy(Process process) {
        ResourceSetImpl resSet = new ResourceSetImpl();
        String path = PATH_MODEL + process.getId() + ".sofia";
        Resource r = resSet.createResource(URI.createURI((String)path));
        r.getContents().add((Object)process);
        try {
            r.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.processManager.getUploadedProcesses().put(process.getId(), path);
        this.deployProcess(process);
        return process.getId();
    }

    public void setClientBuilderFactory(ClientBuilderFactory factory) {
        this.clientBuilderFactory = factory;
    }

    public AbstractClientBuilder createNewClientBuilder() {
        if (this.clientBuilderFactory == null) {
            return null;
        }
        return this.clientBuilderFactory.createClientBuilder();
    }

    public void addStateChangeListener(StateChangeListener stateChangeListener) {
        this.messageQueue.addStateChangeListener(stateChangeListener);
    }

    public void removeStateChangeListener(StateChangeListener stateChangeListener) {
        this.messageQueue.removeStateChangeListener(stateChangeListener);
    }

    public void addHumanTaskRequestListener(HumanTaskRequestListener humanTaskRequestListener) {
        this.messageQueue.addHumanTaskRequestListener(humanTaskRequestListener);
    }

    public void removeHumanTaskRequestListener(HumanTaskRequestListener humanTaskRequestListener) {
        this.messageQueue.removeHumanTaskRequestListener(humanTaskRequestListener);
    }

    public void addHumanTaskResponseLister(HumanTaskResponseListener listener) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void removeHumanTaskResponseListener(HumanTaskResponseListener listener) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void addProcessEngineListener(ProcessEngineListener listener) {
        if (!this.engineListeners.contains(listener)) {
            this.engineListeners.add(listener);
        }
    }

    public void removeProcessEngineListener(ProcessEngineListener listener) {
        this.engineListeners.remove(listener);
    }

    private void printModel(String text) {
        System.out.println("Text: \n" + text);
    }

    private void printPath(String path) {
        System.out.println("Path: " + path);
    }

    private void printUploadedDoc(String doc) {
        System.out.println("uploaded document: \n" + doc);
    }

    private static /* synthetic */ void lambda$deployProcessInstance$1(IProcessInstanceInfo info, ProcessEngineListener l) {
        l.onProcessInstanceDeployed(info);
    }

    private static /* synthetic */ void lambda$deployProcess$0(IProcessInfo info, ProcessEngineListener l) {
        l.onProcessDeployed(info);
    }
}

