/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.distribution.manager;

import eu.vicci.process.distribution.core.DistributedSession;
import eu.vicci.process.distribution.core.RemoteProcess;
import eu.vicci.process.model.sofia.CompositeStep;
import eu.vicci.process.model.sofia.EndPort;
import eu.vicci.process.model.sofia.Process;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class RemoteProcessCache {
    private final Map<String, RemoteProcess> processes = new ConcurrentHashMap<String, RemoteProcess>();
    private final Map<String, DistributedSession> remoteMapping = new ConcurrentHashMap<String, DistributedSession>();

    public RemoteProcess remove(String id) {
        return this.processes.remove(id);
    }

    public RemoteProcess remove(RemoteProcess process) {
        return this.remove(process.getId());
    }

    public RemoteProcess put(String id, RemoteProcess process) {
        return this.processes.put(id, process);
    }

    public RemoteProcess put(RemoteProcess process) {
        return this.put(process.getId(), process);
    }

    public RemoteProcess get(String id) {
        return this.processes.get(id);
    }

    public DistributedSession getSessionFor(String instanceId) {
        return this.remoteMapping.get(instanceId);
    }

    public DistributedSession removeSessionFor(String instanceId) {
        return this.remoteMapping.remove(instanceId);
    }

    public DistributedSession putSessionFor(String instanceId, DistributedSession session) {
        return this.remoteMapping.put(instanceId, session);
    }

    public RemoteProcess createRemoteProcess(Process original) {
        RemoteProcess remote = this.processes.get(original.getId());
        if (remote != null) {
            return remote;
        }
        remote = this.internalCreateRemoteProcess(original);
        this.clearOutTransitions(remote);
        this.put(remote);
        return remote;
    }

    private RemoteProcess internalCreateRemoteProcess(Process original) {
        Process remoteProcess = this.copy(original);
        remoteProcess.setDistributed(false);
        remoteProcess.setRemoteExecuting(true);
        remoteProcess.setCyberPhysical(false);
        boolean runCompensation = original.getGoal() != null && !original.getGoal().isEmpty();
        remoteProcess.setGoal("");
        return new RemoteProcess().setProcess(remoteProcess).setRunCompensation(runCompensation);
    }

    private Process copy(Process original) {
        EList dtDefs = ((Process)this.getRoot((CompositeStep)original)).getDataTypeDefinitions();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Process result = (Process)copier.copy((EObject)original);
        Collection types = copier.copyAll((Collection)dtDefs);
        result.getDataTypeDefinitions().addAll(types);
        copier.copyReferences();
        return result;
    }

    private CompositeStep getRoot(CompositeStep step) {
        if (step.getParentstep() == null) {
            return step;
        }
        return this.getRoot(step.getParentstep());
    }

    private void clearOutTransitions(RemoteProcess remoteProcess) {
        remoteProcess.getProcess().getPorts().stream().filter(p -> p instanceof EndPort).forEach(p -> p.getOutTransitions().clear());
    }
}

