/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.distribution.manager;

import eu.vicci.process.client.ProcessEngineClientBuilder;
import eu.vicci.process.client.core.IProcessEngineClient;
import eu.vicci.process.distribution.core.DistributedSession;
import eu.vicci.process.distribution.core.DistributionManagerListener;
import eu.vicci.process.distribution.core.IDistributionManager;
import eu.vicci.process.distribution.core.PeerProfile;
import eu.vicci.process.distribution.core.RemoteListener;
import eu.vicci.process.distribution.core.RemoteProcess;
import eu.vicci.process.distribution.manager.RemoteProcessCache;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.util.configuration.ConfigurationManager;
import eu.vicci.process.model.util.messages.core.CompensationRequest;
import eu.vicci.process.model.util.messages.core.FeedbackServiceListener;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.StateChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionManager
implements IDistributionManager {
    private static final Logger LOG = LoggerFactory.getLogger(DistributionManager.class);
    private static final String CLIENT_NAME = "SuperPeerDistributionManager";
    private static final String TEMP_CLIENT_NAME = "SuperPeerRemoteExecutingClient";
    private IProcessEngineClient pec;
    private volatile Map<String, PeerProfile> registeredPeers = new HashMap<String, PeerProfile>();
    private volatile Map<String, List<String>> trackedProcessInstances = new HashMap<String, List<String>>();
    private List<DistributionManagerListener> distributionListeners = new ArrayList<DistributionManagerListener>();
    private final RemoteProcessCache remoteProcessCache = new RemoteProcessCache();
    private Map<String, Map<String, DataTypeInstance>> inputParametersCache = new ConcurrentHashMap<String, Map<String, DataTypeInstance>>();
    private Optional<PeerProfile> peerProfile = Optional.empty();
    private StateChangeListener stateChangeListener = new StateChangeListener(){

        public void onMessage(IStateChangeMessage arg) {
            DistributionManager.this.handleStateChange(arg);
        }
    };
    private FeedbackServiceListener feedbackServiceListener = new FeedbackServiceListener(){

        public void onMessage(CompensationRequest request) {
            if (!DistributionManager.checkArgs(request)) {
                LOG.error("CompensationRequest is missing required parameters");
                return;
            }
            DistributedSession oldSession = DistributionManager.this.remoteProcessCache.getSessionFor(request.originalInstanceId);
            DistributionManager.this.removeTrackedInstance(oldSession);
            Map inputParameters = DistributionManager.this.inputParametersCache.containsKey(request.originalInstanceId) ? (Map)DistributionManager.this.inputParametersCache.remove(request.originalInstanceId) : null;
            RemoteProcess process = DistributionManager.this.remoteProcessCache.get(request.processId);
            if (process == null) {
                LOG.error("cant find remote process for id '{}'", (Object)request.processId);
                return;
            }
            DistributionManager.this.executeRemoteProcess(request.newPeerId, request.originalInstanceId, process, inputParameters);
        }
    };

    private DistributionManager() {
        this.pec = this.createSuperPeerClient(CLIENT_NAME);
        this.pec.addStateChangeListener(this.stateChangeListener);
        this.pec.addFeedbackServiceListener(this.feedbackServiceListener);
    }

    public static DistributionManager getInstance() {
        return LazyDistributionManagerHolder.INSTANCE;
    }

    public DistributedSession executeRemoteProcess(String peerId, String runningForInstanceId, RemoteProcess process, Map<String, DataTypeInstance> inputParameters) {
        this.checkExecutionArgs(peerId, runningForInstanceId);
        LOG.info("Execute process '{}' on remote peer '{}'", (Object)process.getName(), (Object)peerId);
        this.remoteProcessCache.put(process.getId(), process);
        IProcessEngineClient tmpPec = this.createSuperPeerClient(TEMP_CLIENT_NAME);
        String pid = tmpPec.deployProcessRemote(peerId, process.getProcess());
        String remoteProcessInstanceId = tmpPec.deployProcessInstanceRemote(peerId, pid);
        DistributedSession newSession = new DistributedSession(remoteProcessInstanceId, peerId);
        this.trackProcessInstance(newSession);
        DistributedSession oldSession = this.remoteProcessCache.putSessionFor(runningForInstanceId, newSession);
        this.informListenersAboutSessionChange(oldSession, newSession);
        if (inputParameters != null) {
            this.inputParametersCache.put(runningForInstanceId, inputParameters);
        }
        tmpPec.startProcessInstanceRemote(peerId, remoteProcessInstanceId, runningForInstanceId, inputParameters);
        return newSession;
    }

    private void checkExecutionArgs(String peerId, String runningForInstanceId) {
        if (runningForInstanceId == null || runningForInstanceId.isEmpty()) {
            throw new RuntimeException("runningForInstanceId cant be null for remote execution");
        }
        if (peerId == null || peerId.isEmpty()) {
            throw new RuntimeException("peerId cant be null for remote execution");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDistributionManagerListener(DistributionManagerListener listener) {
        List<DistributionManagerListener> list = this.distributionListeners;
        synchronized (list) {
            this.distributionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDistributionManagerListener(DistributionManagerListener listener) {
        List<DistributionManagerListener> list = this.distributionListeners;
        synchronized (list) {
            this.distributionListeners.remove(listener);
        }
    }

    public void addRemoteListener(RemoteListener listener) {
    }

    public DistributedSession workRemote(String ip, String runningForInstanceId, RemoteProcess process, Map<String, DataTypeInstance> inputParameters) {
        String peerId = this.getPeerIdForIp(ip);
        return this.executeRemoteProcess(peerId, runningForInstanceId, process, inputParameters);
    }

    public RemoteProcess createRemoteProcess(Process original) {
        return this.remoteProcessCache.createRemoteProcess(original);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPeerIdForIp(String ip) {
        Map<String, PeerProfile> map = this.registeredPeers;
        synchronized (map) {
            PeerProfile profile = this.registeredPeers.get(ip);
            if (profile == null) {
                throw new RuntimeException("no peer was found for ip " + ip);
            }
            return profile.getPeerId();
        }
    }

    private IProcessEngineClient createSuperPeerClient(String name) {
        ProcessEngineClientBuilder builder = new ProcessEngineClientBuilder();
        IProcessEngineClient pec = builder.withIp("localhost").withPort(ConfigurationManager.getInstance().getConfigAsString("PROTEUS_WAMP_PORT")).withName(CLIENT_NAME).withNamespace(ConfigurationManager.getInstance().getConfigAsString("PROTEUS_WAMP_NAMESPACE")).withRealmName(ConfigurationManager.getInstance().getConfigAsString("PROTEUS_WAMP_REALM_NAME")).build();
        pec.connect();
        return pec;
    }

    private void handleStateChange(IStateChangeMessage message) {
        if (message.getPeerId() == null || message.getPeerId().isEmpty() || message.getOriginalProcessInstanceId() == null || message.getOriginalProcessInstanceId().isEmpty()) {
            return;
        }
        if (!this.processHasFinished(message)) {
            return;
        }
        DistributedSession session = this.remoteProcessCache.getSessionFor(message.getOriginalProcessInstanceId());
        if (!this.removeTrackedInstance(session)) {
            return;
        }
        this.informDistributionListeners(message, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTrackedInstance(DistributedSession session) {
        if (session == null) {
            LOG.error("Cant remove a NULL Session from tracked instances");
            return false;
        }
        Map<String, List<String>> map = this.trackedProcessInstances;
        synchronized (map) {
            List<String> instances = this.trackedProcessInstances.get(session.getPeerId());
            if (instances == null || !instances.contains(session.getRemoteInstanceId())) {
                return false;
            }
            return instances.remove(session.getRemoteInstanceId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informDistributionListeners(IStateChangeMessage message, DistributedSession session) {
        List<DistributionManagerListener> list = this.distributionListeners;
        synchronized (list) {
            this.distributionListeners.stream().forEach(l -> l.processOnPeerHasFinished(message, session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informListenersAboutSessionChange(DistributedSession oldSession, DistributedSession newSession) {
        if (oldSession == null || newSession == null) {
            return;
        }
        List<DistributionManagerListener> list = this.distributionListeners;
        synchronized (list) {
            this.distributionListeners.stream().forEach(l -> l.remoteSessionChanged(oldSession, newSession));
        }
    }

    private boolean processHasFinished(IStateChangeMessage message) {
        switch (message.getState()) {
            case EXECUTED: {
                return true;
            }
            case DEACTIVATED: 
            case FAILED: {
                String orgInstanceId = message.getOriginalProcessInstanceId();
                String modelId = message.getProcessModelId();
                RemoteProcess r = this.remoteProcessCache.get(modelId);
                if (orgInstanceId == null || modelId == null || r == null) {
                    LOG.error("received corrupt state change message");
                    return false;
                }
                return !r.isRunCompensation();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPeer(PeerProfile profile) {
        if (!DistributionManager.checkProfile(profile)) {
            return;
        }
        Map<String, PeerProfile> map = this.registeredPeers;
        synchronized (map) {
            this.registeredPeers.put(profile.getIp(), profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPeer(PeerProfile profile) {
        if (!DistributionManager.checkProfile(profile)) {
            return;
        }
        Map<String, PeerProfile> map = this.registeredPeers;
        synchronized (map) {
            this.registeredPeers.remove(profile.getIp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PeerProfile> getRegisteredPeers() {
        HashMap<String, PeerProfile> tmp = new HashMap<String, PeerProfile>();
        Map<String, PeerProfile> map = this.registeredPeers;
        synchronized (map) {
            tmp.putAll(this.registeredPeers);
        }
        return tmp;
    }

    public boolean isSuperPeer() {
        return this.peerProfile.isPresent() && this.peerProfile.get().isSuperPeer();
    }

    public String getPeerId() {
        if (this.peerProfile.isPresent()) {
            return this.peerProfile.get().getPeerId();
        }
        return null;
    }

    public void setPeerProfile(PeerProfile profile) {
        if (profile == null || this.peerProfile.isPresent()) {
            throw new RuntimeException("The PeerProfile can only be set once and cant be set to null");
        }
        this.peerProfile = Optional.of(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackProcessInstance(DistributedSession session) {
        Map<String, List<String>> map = this.trackedProcessInstances;
        synchronized (map) {
            String peerId = session.getPeerId();
            List<String> instances = this.trackedProcessInstances.get(session.getPeerId());
            if (instances == null) {
                instances = new ArrayList<String>();
                this.trackedProcessInstances.put(peerId, instances);
            }
            instances.add(session.getRemoteInstanceId());
        }
    }

    private static boolean checkProfile(PeerProfile profile) {
        if (profile == null || profile.getIp() == null || profile.getPeerId() == null || profile.getIp().isEmpty() || profile.getPeerId().isEmpty()) {
            LOG.error("Corrupt PeerProfile. Cant (un)register peer.");
            return false;
        }
        return true;
    }

    private static boolean checkArgs(CompensationRequest request) {
        return request != null && request.newPeerId != null && !request.newPeerId.isEmpty() && request.processId != null && !request.processId.isEmpty() && request.originalInstanceId != null && !request.originalInstanceId.isEmpty();
    }

    private static class LazyDistributionManagerHolder {
        static final DistributionManager INSTANCE = new DistributionManager();

        private LazyDistributionManagerHolder() {
        }
    }
}

