/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.validation;

import eu.vicci.process.graphiti.Util;
import eu.vicci.process.model.sofia.Identifiable;
import eu.vicci.process.model.sofia.Nameable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ValidationTreeDialog
extends TitleAreaDialog {
    Iterable<ConstraintStatus> status = null;
    Map<EObject, TreeItem> map = null;
    IFeatureProvider featureProvider = null;
    Set<PictogramElement> selected = null;
    Map<PictogramElement, Status> originalStatus = null;
    private static final IColorConstant HIGHLIGHT = new ColorConstant(255, 180, 180);
    Image okImage = null;
    Image errorImage = null;
    Image warningImage = null;

    public ValidationTreeDialog(IFeatureProvider provider, Shell parent, Iterable<ConstraintStatus> status) {
        super(parent);
        this.status = status;
        this.featureProvider = provider;
        this.map = new HashMap<EObject, TreeItem>();
        this.selected = new HashSet<PictogramElement>();
        this.originalStatus = new HashMap<PictogramElement, Status>();
        this.okImage = Util.loadImage("media/ok.png", true);
        this.warningImage = Util.loadImage("media/warning.png", true);
        this.errorImage = Util.loadImage("media/error.png", true);
    }

    private TreeItem buildTree(TreeItem root, EObject object, ConstraintStatus status, Image errorIcon) {
        TreeItem item = null;
        if (this.map.containsKey(object)) {
            item = this.map.get(object);
            if (status != null && object == status.getTarget()) {
                item.setText(String.valueOf(item.getText()) + "\n" + status.getMessage());
                Set objects = (Set)item.getData("EObjects");
                objects.add(object);
                Set locus = status.getResultLocus();
                if (locus != null && !locus.isEmpty()) {
                    for (EObject o : locus) {
                        objects.add(o);
                    }
                }
                item.setImage(errorIcon);
            }
            return item;
        }
        item = object.eContainer() == null ? new TreeItem(root, 2048) : new TreeItem(this.buildTree(root, object.eContainer(), status, errorIcon), 2048);
        String name = null;
        String id = null;
        String type = object.getClass().getSimpleName();
        if (object instanceof Nameable) {
            name = ((Nameable)object).getName();
        }
        if (object instanceof Identifiable) {
            id = ((Identifiable)object).getId();
        }
        item.setText(String.valueOf(type) + " (id: " + id + ") (name: " + name + ")");
        if (status != null && object == status.getTarget()) {
            item.setText(String.valueOf(item.getText()) + "  --> " + status.getMessage());
            HashSet<EObject> objects = new HashSet<EObject>();
            objects.add(object);
            Set locus = status.getResultLocus();
            if (locus != null && !locus.isEmpty()) {
                for (EObject o : locus) {
                    objects.add(o);
                }
            }
            item.setData("EObjects", objects);
            item.setImage(errorIcon);
        }
        this.map.put(object, item);
        return item;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(2144);
        this.setBlockOnOpen(false);
        ValidationTreeDialog.setDialogHelpAvailable((boolean)false);
    }

    protected void okPressed() {
        for (PictogramElement element : this.selected) {
            Status status;
            GraphicsAlgorithm g = element.getGraphicsAlgorithm();
            if (!(g instanceof RoundedRectangle) || (status = this.originalStatus.get(element)) == null) continue;
            ((RoundedRectangle)g).setFilled(Boolean.valueOf(status.isFilled()));
            ((RoundedRectangle)g).setForeground(status.getFgColor());
            ((RoundedRectangle)g).setBackground(status.getBgColor());
        }
        super.okPressed();
    }

    protected void handleShellCloseEvent() {
        for (PictogramElement element : this.selected) {
            Status status;
            GraphicsAlgorithm g = element.getGraphicsAlgorithm();
            if (!(g instanceof RoundedRectangle) || (status = this.originalStatus.get(element)) == null) continue;
            ((RoundedRectangle)g).setFilled(Boolean.valueOf(status.isFilled()));
            ((RoundedRectangle)g).setForeground(status.getFgColor());
            ((RoundedRectangle)g).setBackground(status.getBgColor());
        }
        super.handleShellCloseEvent();
    }

    private void expand(Tree tree) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            this.expand(i);
            ++n2;
        }
    }

    private void expand(TreeItem item) {
        item.setExpanded(true);
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            this.expand(i);
            ++n2;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(1808));
        final Tree tree = new Tree(contents, 2050);
        tree.setBounds(0, 0, 600, 400);
        TreeItem root = new TreeItem(tree, 2048);
        root.setText("Validation Result");
        Image errorIcon = Util.loadImage("media/error-small.png", true);
        for (ConstraintStatus s : this.status) {
            this.buildTree(root, s.getTarget(), s, errorIcon);
        }
        if (root.getItemCount() > 0) {
            this.setTitle("Validation failed");
            this.setTitleImage(this.errorImage);
        } else {
            this.setTitle("Validation succeeded");
            this.setTitleImage(this.okImage);
            root.dispose();
        }
        this.expand(tree);
        tree.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TreeItem[] selection;
                TreeItem[] treeItemArray = selection = tree.getSelection();
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    final HashSet<PictogramElement> elements = new HashSet<PictogramElement>();
                    Set objects = (Set)item.getData("EObjects");
                    if (objects != null) {
                        for (EObject object : objects) {
                            PictogramElement element = ValidationTreeDialog.this.featureProvider.getPictogramElementForBusinessObject((Object)object);
                            if (element == null) continue;
                            elements.add(element);
                        }
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            GraphicsAlgorithm g;
                            Vector<PictogramElement> dirty = new Vector<PictogramElement>();
                            for (PictogramElement s : (this).ValidationTreeDialog.this.selected) {
                                Status status;
                                if (s == null) continue;
                                dirty.add(s);
                                g = s.getGraphicsAlgorithm();
                                if (!(g instanceof RoundedRectangle) || (status = (this).ValidationTreeDialog.this.originalStatus.get(s)) == null) continue;
                                ((RoundedRectangle)g).setFilled(Boolean.valueOf(status.isFilled()));
                                ((RoundedRectangle)g).setForeground(status.getFgColor());
                                ((RoundedRectangle)g).setBackground(status.getBgColor());
                            }
                            (this).ValidationTreeDialog.this.selected.clear();
                            for (PictogramElement element : elements) {
                                if (element == null) continue;
                                g = element.getGraphicsAlgorithm();
                                if (!(this).ValidationTreeDialog.this.originalStatus.containsKey(element) && g instanceof RoundedRectangle) {
                                    RoundedRectangle r = (RoundedRectangle)g;
                                    Status status = new Status(r.getForeground(), r.getBackground(), r.getFilled());
                                    (this).ValidationTreeDialog.this.originalStatus.put(element, status);
                                }
                                (this).ValidationTreeDialog.this.selected.add(element);
                                dirty.add(element);
                                if (!(g instanceof RoundedRectangle)) continue;
                                IGaService gaService = Graphiti.getGaService();
                                ((RoundedRectangle)g).setFilled(Boolean.valueOf(true));
                                ((RoundedRectangle)g).setBackground(gaService.manageColor((this).ValidationTreeDialog.this.featureProvider.getDiagramTypeProvider().getDiagram(), HIGHLIGHT));
                            }
                            if (dirty.size() > 0) {
                                (this).ValidationTreeDialog.this.featureProvider.getDiagramTypeProvider().getNotificationService().updatePictogramElements(dirty.toArray(new PictogramElement[dirty.size()]));
                                (this).ValidationTreeDialog.this.featureProvider.getDiagramTypeProvider().getDiagramBehavior().refresh();
                            }
                        }
                    });
                    ++n2;
                }
            }
        });
        return contents;
    }

    private class Status {
        private Color fgColor;
        private Color bgColor;
        private boolean filled;

        public Color getFgColor() {
            return this.fgColor;
        }

        public Color getBgColor() {
            return this.bgColor;
        }

        public boolean isFilled() {
            return this.filled;
        }

        Status(Color fgColor, Color bgColor, boolean filled) {
            this.fgColor = fgColor;
            this.bgColor = bgColor;
            this.filled = filled;
        }
    }
}

