/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.validation;

import eu.vicci.process.graphiti.validation.ValidationTreeDialog;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ValidateFeature
extends AbstractCustomFeature {
    private IFeatureProvider featureProvider;

    public ValidateFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
        this.featureProvider = featureProvider;
    }

    public boolean canUndo(IContext arg0) {
        return false;
    }

    void flatten(IStatus status, Vector<ConstraintStatus> result) {
        if (status == null) {
            return;
        }
        if (status instanceof ConstraintStatus) {
            result.add((ConstraintStatus)status);
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus s = iStatusArray[n2];
            this.flatten(s, result);
            ++n2;
        }
    }

    public void execute(IContext context) {
        IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        validator.setIncludeLiveConstraints(true);
        Diagram diagram = this.getDiagram();
        ArrayList<EObject> objects = new ArrayList<EObject>();
        EList shapes = diagram.getChildren();
        for (Shape shape : shapes) {
            EObject object = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)shape);
            if (object == null) continue;
            objects.add(object);
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Vector<ConstraintStatus> validationStatus = new Vector<ConstraintStatus>();
        IStatus state = validator.validate(objects);
        this.flatten(state, validationStatus);
        ValidationTreeDialog dialog = new ValidationTreeDialog(this.getFeatureProvider(), shell, validationStatus);
        dialog.open();
    }

    public boolean hasDoneChanges() {
        return false;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public String getName() {
        return "Validate";
    }

    public String getDescription() {
        return "Validate Description";
    }

    public IFeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public boolean canExecute(ICustomContext arg0) {
        return true;
    }

    public void execute(ICustomContext arg0) {
    }
}

