/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.Condition;
import eu.vicci.process.model.sofia.DataPort;
import eu.vicci.process.model.sofia.Loop;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.StartDataPort;
import eu.vicci.process.model.sofia.WhileLoop;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class WhileLoopSection
extends PropertySectionBase
implements FocusListener,
SelectionListener {
    private TabbedPropertySheetWidgetFactory factory;
    private Composite flatFormComposite;
    private CCombo conditionLeftValueCCombo;
    private CCombo conditionRightValueCCombo;
    private List<StartDataPort> startDataPorts = new ArrayList<StartDataPort>();

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.factory = this.getWidgetFactory();
        this.flatFormComposite = this.factory.createFlatFormComposite(parent);
        this.setConditionLeftCCombo();
        this.setConditionLeftCLabel();
        this.setConditionRightCCombo();
        this.setConditionRightCLabel();
    }

    public void refresh() {
        super.refresh();
        WhileLoop loop = this.getLoopElement();
        if (loop == null) {
            return;
        }
        this.fillLists((Loop)loop);
        Condition loopCondition = loop.getLoopCondition();
        if (loopCondition == null) {
            return;
        }
        this.conditionLeftValueCCombo.select(this.startDataPorts.indexOf(loopCondition.getLeftSide()));
        this.conditionRightValueCCombo.select(this.startDataPorts.indexOf(loopCondition.getRightSide()));
    }

    public void widgetSelected(SelectionEvent e) {
        this.focusLost(null);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.focusLost(null);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        final WhileLoop loop = this.getLoopElement();
        if (loop == null) {
            return;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)loop);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
            ProcessFeatureProvider featureProvider;
            {
                super($anonymous0);
                this.featureProvider = WhileLoopSection.this.getProcessFeatureProvider();
            }

            protected void doExecute() {
                Condition loopCondition = loop.getLoopCondition();
                try {
                    loopCondition.setLeftSide((StartDataPort)WhileLoopSection.this.startDataPorts.get(WhileLoopSection.this.conditionLeftValueCCombo.getSelectionIndex()));
                    loopCondition.setRightSide((StartDataPort)WhileLoopSection.this.startDataPorts.get(WhileLoopSection.this.conditionRightValueCCombo.getSelectionIndex()));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(WhileLoopSection.this.getSelectedPictogramElement()));
            }
        });
    }

    private void setConditionRightCCombo() {
        this.conditionRightValueCCombo = this.factory.createCCombo(this.flatFormComposite);
        FormData data = new FormData();
        for (DataPort dataPort : this.startDataPorts) {
            this.conditionRightValueCCombo.add(dataPort.getName());
        }
        data.left = new FormAttachment((Control)this.conditionLeftValueCCombo, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.conditionRightValueCCombo.setLayoutData((Object)data);
        this.conditionRightValueCCombo.addFocusListener((FocusListener)this);
        this.conditionRightValueCCombo.addSelectionListener((SelectionListener)this);
    }

    private void setConditionLeftCCombo() {
        FormData data = new FormData();
        this.conditionLeftValueCCombo = this.factory.createCCombo(this.flatFormComposite);
        for (DataPort dataPort : this.startDataPorts) {
            this.conditionLeftValueCCombo.add(dataPort.getName());
        }
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment(0, 4);
        this.conditionLeftValueCCombo.setLayoutData((Object)data);
        this.conditionLeftValueCCombo.addFocusListener((FocusListener)this);
        this.conditionLeftValueCCombo.addSelectionListener((SelectionListener)this);
    }

    private void setConditionLeftCLabel() {
        CLabel valueLabel = this.factory.createCLabel(this.flatFormComposite, "Left:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.conditionLeftValueCCombo, -5);
        data.top = new FormAttachment((Control)this.conditionLeftValueCCombo, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    private void setConditionRightCLabel() {
        CLabel valueLabel = this.factory.createCLabel(this.flatFormComposite, "Right:");
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.conditionLeftValueCCombo, 0);
        data.right = new FormAttachment((Control)this.conditionRightValueCCombo, -5);
        data.top = new FormAttachment((Control)this.conditionRightValueCCombo, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    private WhileLoop getLoopElement() {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(this.getSelectedPictogramElement());
        if (bo != null) {
            return (WhileLoop)bo;
        }
        return null;
    }

    private void fillLists(Loop loop) {
        this.conditionLeftValueCCombo.removeAll();
        this.conditionRightValueCCombo.removeAll();
        this.startDataPorts.clear();
        for (Port port : loop.getPorts()) {
            if (!(port instanceof StartDataPort) || this.startDataPorts.contains(port)) continue;
            this.conditionLeftValueCCombo.add(port.getName());
            this.conditionRightValueCCombo.add(port.getName());
            this.startDataPorts.add((StartDataPort)port);
        }
    }
}

