/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.SeMiWaRequest;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class SeMiWaRequestSection
extends PropertySectionBase {
    private Text ssilText;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.ssilText = factory.createText(composite, "");
        this.ssilText.setEditable(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.ssilText.setLayoutData((Object)data);
        this.ssilText.addFocusListener((FocusListener)new StateFocusListener());
        this.ssilText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        CLabel valueLabel = factory.createCLabel(composite, "SSIL Statement:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.ssilText, -5);
        data.top = new FormAttachment((Control)this.ssilText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        EObject bo;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof SeMiWaRequest) {
            String s = ((SeMiWaRequest)bo).getSSILStatement();
            this.ssilText.setText(s == null ? "" : s);
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            final PictogramElement pe = SeMiWaRequestSection.this.getSelectedPictogramElement();
            if (pe != null) {
                final EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                final Map<String, org.eclipse.graphiti.mm.algorithms.Text> map = AttributeMap.instance().getObjectMap(bo);
                if (bo instanceof SeMiWaRequest) {
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = SeMiWaRequestSection.this.getProcessFeatureProvider();
                        }

                        protected void doExecute() {
                            String s = SeMiWaRequestSection.this.ssilText.getText();
                            if (s != null) {
                                org.eclipse.graphiti.mm.algorithms.Text text;
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("ssil")) != null) {
                                    text.setValue("SSIL: " + s);
                                }
                                ((SeMiWaRequest)bo).setSSILStatement(s);
                            }
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
            }
        }
    }
}

