/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.Process;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class RemoteSection
extends PropertySectionBase {
    private Button isDistributed;
    private Text exPeer;
    private FocusListener focusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            final Process pe = RemoteSection.this.getProcessElement();
            if (pe == null) {
                return;
            }
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)pe);
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                ProcessFeatureProvider featureProvider;
                {
                    super($anonymous0);
                    this.featureProvider = RemoteSection.this.getProcessFeatureProvider();
                }

                protected void doExecute() {
                    pe.setDistributed(RemoteSection.this.isDistributed.getSelection());
                    String executionPeer = RemoteSection.this.exPeer.getText();
                    if (executionPeer != null && !executionPeer.isEmpty()) {
                        pe.setExecutionPeer(executionPeer);
                    }
                    this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(RemoteSection.this.getSelectedPictogramElement()));
                }
            });
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.isDistributed = factory.createButton(composite, "Distributed", 32);
        this.isDistributed.setEnabled(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.isDistributed.setLayoutData((Object)data);
        this.isDistributed.addFocusListener(this.focusListener);
        composite = factory.createFlatFormComposite(parent);
        this.exPeer = factory.createText(composite, "");
        this.exPeer.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment((Control)this.isDistributed, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.exPeer.setLayoutData((Object)data);
        this.exPeer.addFocusListener(this.focusListener);
        CLabel valueLabel = factory.createCLabel(composite, "Execution Peer:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.isDistributed, 0);
        data.right = new FormAttachment((Control)this.exPeer, -5);
        data.top = new FormAttachment((Control)this.exPeer, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite.layout(true, true);
    }

    private Process getProcessElement() {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(this.getSelectedPictogramElement());
        if (bo != null) {
            return (Process)bo;
        }
        return null;
    }

    public void refresh() {
        Process p = this.getProcessElement();
        if (p == null) {
            return;
        }
        if (this.isDistributed.isDisposed() || this.exPeer.isDisposed()) {
            return;
        }
        this.isDistributed.setSelection(p.isDistributed());
        this.exPeer.setEnabled(true);
        this.exPeer.setText(p.getExecutionPeer() == null ? "" : p.getExecutionPeer());
    }
}

