/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.Port;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PortSection
extends PropertySectionBase {
    private Button optional;
    private Text portDescription;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createDescription(composite);
        this.createOptional(composite);
    }

    private void createOptional(Composite parent) {
        this.optional = this.getWidgetFactory().createButton(parent, "optional", 32);
        this.optional.setEnabled(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.portDescription, 4);
        this.optional.setLayoutData((Object)data);
        this.optional.addFocusListener((FocusListener)new OptionalFocusListener());
    }

    private void createDescription(Composite parent) {
        this.portDescription = this.getWidgetFactory().createText(parent, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.portDescription.setLayoutData((Object)data);
        this.portDescription.addFocusListener((FocusListener)new DescriptionFocusListener());
        CLabel valueLabel = this.getWidgetFactory().createCLabel(parent, "Description:");
        FormData labelData = new FormData();
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment((Control)this.portDescription, -5);
        labelData.top = new FormAttachment((Control)this.portDescription, 0, 0x1000000);
        valueLabel.setLayoutData((Object)labelData);
    }

    public void refresh() {
        EObject bo;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof Port) {
            Port port = (Port)bo;
            this.optional.setSelection(port.isOptional());
            this.portDescription.setText(port.getDescription() == null ? "" : port.getDescription());
        }
    }

    private void writeToModel() {
        EObject bo;
        final PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof Port) {
            final Port port = (Port)bo;
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                ProcessFeatureProvider featureProvider;
                {
                    super($anonymous0);
                    this.featureProvider = PortSection.this.getProcessFeatureProvider();
                }

                protected void doExecute() {
                    port.setOptional(PortSection.this.optional.getSelection());
                    port.setDescription(PortSection.this.portDescription.getText());
                    this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                }
            });
        }
    }

    private class DescriptionFocusListener
    implements FocusListener {
        private String oldDesc = "";

        private DescriptionFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            this.oldDesc = PortSection.this.portDescription.getText();
        }

        public void focusLost(FocusEvent e) {
            if (!this.oldDesc.equals(PortSection.this.portDescription.getText())) {
                PortSection.this.writeToModel();
            }
        }
    }

    private class OptionalFocusListener
    implements FocusListener {
        private boolean oldValue = false;

        private OptionalFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            this.oldValue = PortSection.this.optional.getSelection();
        }

        public void focusLost(FocusEvent e) {
            if (this.oldValue != PortSection.this.optional.getSelection()) {
                PortSection.this.writeToModel();
            }
        }
    }
}

