/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.OpenHabSemanticAskInvoke;
import eu.vicci.process.model.sofia.OpenHabSemanticCommandInvoke;
import eu.vicci.process.model.sofia.OpenHabSemanticInvoke;
import eu.vicci.process.model.sofia.OpenHabSemanticSelectInvoke;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class OpenHabSemanticInvokeSection
extends PropertySectionBase {
    private static final String DEFAULT_BASE_URI = "not needed anymore (field only for backwards comp.)";
    private static final String[] COMMANDS = new String[]{"ON", "OFF", "TOGGLE", "UP", "DOWN"};
    private static final String DEFAULT_PREFIX = "PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nPREFIX dogont:<http://elite.polito.it/ontologies/dogont.owl#>\nPREFIX instance:<http://openhab-semantic/0.1/instance#>\nPREFIX vicci:<http://openhab-semantic/0.1/dogont-vicci-extension#>\nPREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\n\n";
    private static final String DEFAULT_SELECT_STMT = "PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nPREFIX dogont:<http://elite.polito.it/ontologies/dogont.owl#>\nPREFIX instance:<http://openhab-semantic/0.1/instance#>\nPREFIX vicci:<http://openhab-semantic/0.1/dogont-vicci-extension#>\nPREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\n\nSELECT *\nWHERE {\n?subject rdfs:subClassOf ?object .\n}";
    private static final String DEFAULT_ASK_STMT = "PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nPREFIX dogont:<http://elite.polito.it/ontologies/dogont.owl#>\nPREFIX instance:<http://openhab-semantic/0.1/instance#>\nPREFIX vicci:<http://openhab-semantic/0.1/dogont-vicci-extension#>\nPREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\n\nASK\n{...}";
    private static final String DEFAULT_COMMAND_STMT = "PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nPREFIX dogont:<http://elite.polito.it/ontologies/dogont.owl#>\nPREFIX instance:<http://openhab-semantic/0.1/instance#>\nPREFIX vicci:<http://openhab-semantic/0.1/dogont-vicci-extension#>\nPREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\n\nSELECT ?func\nWHERE {\n?subject dogont:hasFunctionality ?func.\n}";
    private static final int QUERY_TEXT_WIDTH = 900;
    private static final int QUERY_TEXT_HEIGHT = 500;
    private static final int URI_WIDTH = 1000;
    private static final int TYPE_WIDTH = 125;
    private Text baseUriText;
    private Text queryText;
    private CCombo commandCombo;
    private Button radioSelect;
    private Button radioAsk;
    private Button radioCommand;
    private Button checkWithLatest;
    private String oldSelectStmt = null;
    private String oldAskStmt = null;
    private String oldCommandStmt = null;
    private Button oldSelectedButton = null;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        RowLayout layout = new RowLayout(512);
        layout.fill = true;
        layout.wrap = false;
        layout.justify = false;
        parent.setLayout((Layout)layout);
        this.createUriPart(factory, parent);
        Composite queryAndCommandAndTypeComposite = factory.createFlatFormComposite(parent);
        queryAndCommandAndTypeComposite.setLayout((Layout)new GridLayout(2, false));
        RowData rowData = new RowData();
        queryAndCommandAndTypeComposite.setLayoutData((Object)rowData);
        Composite typeAndWithLatestComposite = factory.createFlatFormComposite(queryAndCommandAndTypeComposite);
        typeAndWithLatestComposite.setLayout((Layout)new RowLayout(512));
        GridData typeGridData = new GridData(1, 128, true, true);
        typeGridData.widthHint = 125;
        typeAndWithLatestComposite.setLayoutData((Object)typeGridData);
        this.createTypePart(factory, typeAndWithLatestComposite);
        this.createWithLatestPart(factory, typeAndWithLatestComposite);
        Composite queryAndCommandComposite = factory.createComposite(queryAndCommandAndTypeComposite, 0);
        RowLayout queryAndCommandLayout = new RowLayout(512);
        queryAndCommandLayout.fill = true;
        queryAndCommandComposite.setLayout((Layout)queryAndCommandLayout);
        GridData gridData = new GridData(1808);
        queryAndCommandComposite.setLayoutData((Object)gridData);
        this.createCommandPart(factory, queryAndCommandComposite);
        this.createQueryPart(factory, queryAndCommandComposite);
    }

    public void refresh() {
        super.refresh();
        OpenHabSemanticInvoke openhab = this.getOpenHabElement();
        if (openhab == null) {
            return;
        }
        this.setServerBaseAddress(openhab);
        this.setTargetTypeAndQuery(openhab);
        this.setCommand(openhab);
        this.checkWithLatest.setSelection(openhab.isWithLatest());
    }

    private void setCommand(OpenHabSemanticInvoke openhab) {
    }

    private void setTargetTypeAndQuery(OpenHabSemanticInvoke openhab) {
        if (openhab instanceof OpenHabSemanticSelectInvoke) {
            this.radioSelect.setSelection(true);
            this.resetQuery(openhab.getQuery(), DEFAULT_SELECT_STMT);
            this.oldSelectedButton = this.radioSelect;
            this.commandCombo.setEnabled(false);
        } else if (openhab instanceof OpenHabSemanticAskInvoke) {
            this.radioAsk.setSelection(true);
            this.resetQuery(openhab.getQuery(), DEFAULT_ASK_STMT);
            this.oldSelectedButton = this.radioAsk;
            this.commandCombo.setEnabled(false);
        } else if (openhab instanceof OpenHabSemanticCommandInvoke) {
            this.radioCommand.setSelection(true);
            this.resetQuery(openhab.getQuery(), DEFAULT_COMMAND_STMT);
            this.oldSelectedButton = this.radioCommand;
            this.commandCombo.setEnabled(true);
        }
    }

    private void setServerBaseAddress(OpenHabSemanticInvoke openhab) {
        if (openhab.getServerBaseAddress() == null || openhab.getServerBaseAddress().isEmpty()) {
            this.baseUriText.setText(DEFAULT_BASE_URI);
        } else {
            this.baseUriText.setText(openhab.getServerBaseAddress());
        }
    }

    private void createWithLatestPart(TabbedPropertySheetWidgetFactory factory, Composite parent) {
        this.checkWithLatest = factory.createButton(parent, "with Latest", 32);
        this.checkWithLatest.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OpenHabSemanticInvokeSection.this.writeToModel();
            }
        });
    }

    private void createTypePart(TabbedPropertySheetWidgetFactory factory, Composite parent) {
        Group group = factory.createGroup(parent, "Type");
        group.setLayout((Layout)new FillLayout(512));
        this.radioSelect = factory.createButton((Composite)group, "Select", 16);
        this.radioAsk = factory.createButton((Composite)group, "Ask", 16);
        this.radioCommand = factory.createButton((Composite)group, "Command", 16);
        this.radioSelect.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OpenHabSemanticInvokeSection.this.onRadioSelectSelection(event);
            }
        });
        this.radioAsk.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OpenHabSemanticInvokeSection.this.onRadioAskSelection(event);
            }
        });
        this.radioCommand.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OpenHabSemanticInvokeSection.this.onRadioCommandSelection(event);
            }
        });
        group.setVisible(false);
    }

    private void createCommandPart(TabbedPropertySheetWidgetFactory factory, Composite parent) {
        Composite commandComposite = factory.createFlatFormComposite(parent);
        RowData rowData = new RowData();
        commandComposite.setLayoutData((Object)rowData);
        Label commandLabel = factory.createLabel(commandComposite, "Command:");
        this.commandCombo = factory.createCCombo(commandComposite, 8);
        this.commandCombo.setItems(COMMANDS);
        this.commandCombo.select(0);
        this.commandCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OpenHabSemanticInvokeSection.this.writeToModel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                OpenHabSemanticInvokeSection.this.writeToModel();
            }
        });
        commandLabel.setVisible(false);
        this.commandCombo.setVisible(false);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 85);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 4);
        this.commandCombo.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.commandCombo, 5);
        formData.top = new FormAttachment((Control)this.commandCombo, 0, 0x1000000);
        commandLabel.setLayoutData((Object)formData);
    }

    private void createQueryPart(TabbedPropertySheetWidgetFactory factory, Composite parent) {
        Composite queryComposite = factory.createFlatFormComposite(parent);
        queryComposite.setLayout((Layout)new FillLayout());
        RowData rowData = new RowData();
        rowData.height = 500;
        rowData.width = 900;
        queryComposite.setLayoutData((Object)rowData);
        this.queryText = factory.createText(queryComposite, "", 2626);
        this.queryText.addFocusListener(new FocusListener(){
            private String oldValue = "";

            public void focusLost(FocusEvent e) {
                if (!this.oldValue.equals(OpenHabSemanticInvokeSection.this.queryText.getText())) {
                    OpenHabSemanticInvokeSection.this.writeToModel();
                }
            }

            public void focusGained(FocusEvent e) {
                this.oldValue = OpenHabSemanticInvokeSection.this.queryText.getText();
            }
        });
    }

    private void createUriPart(TabbedPropertySheetWidgetFactory factory, Composite parent) {
        Composite uriComposite = factory.createFlatFormComposite(parent);
        RowData data = new RowData();
        data.width = 1000;
        uriComposite.setLayoutData((Object)data);
        Label uriLabel = factory.createLabel(uriComposite, "Base Uri: ");
        this.baseUriText = factory.createText(uriComposite, DEFAULT_BASE_URI);
        this.baseUriText.addFocusListener(new FocusListener(){
            private String oldValue = "";

            public void focusLost(FocusEvent e) {
                if (!this.oldValue.equals(OpenHabSemanticInvokeSection.this.baseUriText.getText())) {
                    OpenHabSemanticInvokeSection.this.writeToModel();
                }
            }

            public void focusGained(FocusEvent e) {
                this.oldValue = OpenHabSemanticInvokeSection.this.baseUriText.getText();
            }
        });
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 85);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 4);
        this.baseUriText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.baseUriText, -5);
        formData.top = new FormAttachment((Control)this.baseUriText, 0, 0x1000000);
        uriLabel.setLayoutData((Object)formData);
    }

    private void onRadioCommandSelection(Event event) {
        this.setOldQueryToTemp();
        this.resetQuery(this.oldCommandStmt, DEFAULT_COMMAND_STMT);
        this.oldSelectedButton = this.radioCommand;
        this.commandCombo.setEnabled(true);
        this.writeToModel();
    }

    private void onRadioAskSelection(Event event) {
        this.setOldQueryToTemp();
        this.resetQuery(this.oldAskStmt, DEFAULT_ASK_STMT);
        this.oldSelectedButton = this.radioAsk;
        this.commandCombo.setEnabled(false);
        this.writeToModel();
    }

    private void onRadioSelectSelection(Event event) {
        this.setOldQueryToTemp();
        this.resetQuery(this.oldSelectStmt, DEFAULT_SELECT_STMT);
        this.oldSelectedButton = this.radioSelect;
        this.commandCombo.setEnabled(false);
        this.writeToModel();
    }

    private void resetQuery(String oldStmt, String defaultStmt) {
        if (oldStmt == null || oldStmt.isEmpty()) {
            this.queryText.setText(defaultStmt);
        } else {
            this.queryText.setText(oldStmt);
        }
    }

    private void setOldQueryToTemp() {
        if (this.radioAsk.equals(this.oldSelectedButton)) {
            this.oldAskStmt = this.queryText.getText();
        } else if (this.radioCommand.equals(this.oldSelectedButton)) {
            this.oldCommandStmt = this.queryText.getText();
        } else if (this.radioSelect.equals(this.oldSelectedButton)) {
            this.oldSelectStmt = this.queryText.getText();
        }
    }

    private OpenHabSemanticInvoke getOpenHabElement() {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(this.getSelectedPictogramElement());
        if (bo != null) {
            return (OpenHabSemanticInvoke)bo;
        }
        return null;
    }

    private void writeToModel() {
        final OpenHabSemanticInvoke openhab = this.getOpenHabElement();
        if (openhab == null) {
            return;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)openhab);
        final Map<String, org.eclipse.graphiti.mm.algorithms.Text> map = AttributeMap.instance().getObjectMap(openhab);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
            ProcessFeatureProvider featureProvider;
            {
                super($anonymous0);
                this.featureProvider = OpenHabSemanticInvokeSection.this.getProcessFeatureProvider();
            }

            protected void doExecute() {
                try {
                    org.eclipse.graphiti.mm.algorithms.Text text;
                    openhab.setQuery(OpenHabSemanticInvokeSection.this.queryText.getText());
                    openhab.setServerBaseAddress(OpenHabSemanticInvokeSection.this.baseUriText.getText());
                    openhab.setWithLatest(OpenHabSemanticInvokeSection.this.checkWithLatest.getSelection());
                    if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("baseuri")) != null) {
                        text.setValue("baseuri: " + OpenHabSemanticInvokeSection.this.baseUriText.getText());
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(OpenHabSemanticInvokeSection.this.getSelectedPictogramElement()));
            }
        });
    }
}

