/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.OpenHabSemanticCommandInvoke;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class OpenHabSemanticCommandInvokeSection
extends PropertySectionBase {
    private static final String[] COMMANDS = new String[]{"ON", "OFF", "TOGGLE", "UP", "DOWN", "PLAY", "STOP"};
    private CCombo commandCombo;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.createCommandPart(factory, parent);
    }

    public void refresh() {
        super.refresh();
        OpenHabSemanticCommandInvoke openhab = this.getOpenHabElement();
        if (openhab == null) {
            return;
        }
        this.setCommand(openhab);
    }

    private void createCommandPart(TabbedPropertySheetWidgetFactory factory, Composite parent) {
        Composite commandComposite = factory.createFlatFormComposite(parent);
        Label commandLabel = factory.createLabel(commandComposite, "Command:");
        this.commandCombo = factory.createCCombo(commandComposite);
        this.commandCombo.setItems(COMMANDS);
        this.commandCombo.select(0);
        this.commandCombo.setEditable(true);
        this.commandCombo.addFocusListener(new FocusListener(){
            private String oldValue = "";

            public void focusLost(FocusEvent e) {
                if (!this.oldValue.equals(OpenHabSemanticCommandInvokeSection.this.commandCombo.getText())) {
                    OpenHabSemanticCommandInvokeSection.this.writeToModel();
                }
            }

            public void focusGained(FocusEvent e) {
                this.oldValue = OpenHabSemanticCommandInvokeSection.this.commandCombo.getText();
            }
        });
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 85);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 4);
        this.commandCombo.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.commandCombo, 5);
        formData.top = new FormAttachment((Control)this.commandCombo, 0, 0x1000000);
        commandLabel.setLayoutData((Object)formData);
    }

    private void setCommand(OpenHabSemanticCommandInvoke openhab) {
        String command;
        List<String> tmp = Arrays.asList(COMMANDS);
        int index = tmp.lastIndexOf(command = openhab.getCommand());
        if (index < 0) {
            if (command == null) {
                this.commandCombo.select(0);
            } else {
                this.commandCombo.setText(command);
            }
        } else {
            this.commandCombo.select(index);
        }
    }

    private OpenHabSemanticCommandInvoke getOpenHabElement() {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(this.getSelectedPictogramElement());
        if (bo != null) {
            return (OpenHabSemanticCommandInvoke)bo;
        }
        return null;
    }

    private void writeToModel() {
        final OpenHabSemanticCommandInvoke openhab = this.getOpenHabElement();
        if (openhab == null) {
            return;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)openhab);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
            ProcessFeatureProvider featureProvider;
            {
                super($anonymous0);
                this.featureProvider = OpenHabSemanticCommandInvokeSection.this.getProcessFeatureProvider();
            }

            protected void doExecute() {
                try {
                    openhab.setCommand(OpenHabSemanticCommandInvokeSection.this.commandCombo.getText());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(OpenHabSemanticCommandInvokeSection.this.getSelectedPictogramElement()));
            }
        });
    }
}

