/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.property;

import eu.vicci.process.graphiti.AttributeMap;
import eu.vicci.process.graphiti.ProcessFeatureProvider;
import eu.vicci.process.graphiti.Util;
import eu.vicci.process.graphiti.WsdlTypeImporter;
import eu.vicci.process.graphiti.property.PropertySectionBase;
import eu.vicci.process.model.sofia.CompositeStep;
import eu.vicci.process.model.sofia.OSGiInvoke;
import eu.vicci.process.model.sofia.ProcessStep;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class OSGiInvokeSection
extends PropertySectionBase {
    private Text serviceClassNameText;
    private Text methodText;
    private Text parameterTypesText;
    private Text bundleNameText;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        this.serviceClassNameText = factory.createText(composite, "");
        this.serviceClassNameText.setEditable(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.serviceClassNameText.setLayoutData((Object)data);
        this.serviceClassNameText.addFocusListener((FocusListener)new StateFocusListener());
        this.serviceClassNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        CLabel valueLabel = factory.createCLabel(composite, "Service Class Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.serviceClassNameText, -5);
        data.top = new FormAttachment((Control)this.serviceClassNameText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.methodText = factory.createText(composite, "");
        this.methodText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.methodText.setLayoutData((Object)data);
        this.methodText.addFocusListener((FocusListener)new StateFocusListener());
        this.methodText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "Method:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.methodText, -5);
        data.top = new FormAttachment((Control)this.methodText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.parameterTypesText = factory.createText(composite, "");
        this.parameterTypesText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.parameterTypesText.setLayoutData((Object)data);
        this.parameterTypesText.addFocusListener((FocusListener)new StateFocusListener());
        this.parameterTypesText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "Parameter Types:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.parameterTypesText, -5);
        data.top = new FormAttachment((Control)this.parameterTypesText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        composite = factory.createFlatFormComposite(parent);
        this.bundleNameText = factory.createText(composite, "");
        this.bundleNameText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.bundleNameText.setLayoutData((Object)data);
        this.bundleNameText.addFocusListener((FocusListener)new StateFocusListener());
        this.bundleNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    new StateFocusListener().focusLost(null);
                }
            }
        });
        valueLabel = factory.createCLabel(composite, "Bundle:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.bundleNameText, -5);
        data.top = new FormAttachment((Control)this.bundleNameText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        EObject bo;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null && (bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof OSGiInvoke) {
            String s = ((OSGiInvoke)bo).getServiceClassName();
            this.serviceClassNameText.setText(s == null ? "" : s);
            s = ((OSGiInvoke)bo).getMethodName();
            this.methodText.setText(s == null ? "" : s);
            s = ((OSGiInvoke)bo).getParameterTypes();
            this.parameterTypesText.setText(s == null ? "" : s);
            s = ((OSGiInvoke)bo).getBundleName();
            this.bundleNameText.setText(s == null ? "" : s);
        }
    }

    private class StateFocusListener
    implements FocusListener {
        private StateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            final PictogramElement pe = OSGiInvokeSection.this.getSelectedPictogramElement();
            if (pe != null) {
                final EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                final Map<String, org.eclipse.graphiti.mm.algorithms.Text> map = AttributeMap.instance().getObjectMap(bo);
                if (bo instanceof OSGiInvoke) {
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)bo);
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){
                        ProcessFeatureProvider featureProvider;
                        {
                            super($anonymous0);
                            this.featureProvider = OSGiInvokeSection.this.getProcessFeatureProvider();
                        }

                        protected void doExecute() {
                            org.eclipse.graphiti.mm.algorithms.Text text;
                            String s = OSGiInvokeSection.this.serviceClassNameText.getText();
                            if (s != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("service")) != null) {
                                    text.setValue("service: " + s);
                                }
                                ((OSGiInvoke)bo).setServiceClassName(s);
                            }
                            if ((s = OSGiInvokeSection.this.methodText.getText()) != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("method")) != null) {
                                    text.setValue("method: " + s);
                                    System.out.println("width: " + text.getWidth());
                                }
                                ((OSGiInvoke)bo).setMethodName(s);
                            }
                            if ((s = OSGiInvokeSection.this.parameterTypesText.getText()) != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("parameter")) != null) {
                                    text.setValue("parameter: " + s);
                                    System.out.println("width: " + text.getWidth());
                                }
                                if (!s.equals(((OSGiInvoke)bo).getParameterTypes())) {
                                    ((OSGiInvoke)bo).setParameterTypes(s);
                                    System.out.println("s = " + s + "  wsdlUri = " + ((OSGiInvoke)bo).getParameterTypes());
                                    CompositeStep rootParent = ((OSGiInvoke)bo).getParentstep();
                                    while (rootParent.getParentstep() != null && rootParent instanceof ProcessStep && rootParent != rootParent.getParentstep()) {
                                        rootParent = rootParent.getParentstep();
                                    }
                                    WsdlTypeImporter.parse(s, this.featureProvider, Util.getContainerForBusinessObject(OSGiInvokeSection.this.getDiagram(), rootParent), OSGiInvokeSection.this.getDiagram());
                                }
                            }
                            if ((s = OSGiInvokeSection.this.bundleNameText.getText()) != null) {
                                if (map != null && (text = (org.eclipse.graphiti.mm.algorithms.Text)map.get("bundle")) != null) {
                                    text.setValue("bundle: " + s);
                                    System.out.println("width: " + text.getWidth());
                                }
                                ((OSGiInvoke)bo).setBundleName(s);
                            }
                            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pe));
                        }
                    });
                }
            }
        }
    }
}

